/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.util.csv.CSVFileReader;
import com.logicaldoc.util.csv.CSVFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveCache
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ArchiveCache.class);
    private File file;
    private String lastId = null;

    public ArchiveCache(File file) throws IOException {
        this.file = file;
        if (!file.exists()) {
            FileUtils.touch(file);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void read() throws IOException {
        this.clear();
        Throwable throwable = null;
        Object var2_3 = null;
        try (CSVFileReader reader = new CSVFileReader(this.file.getPath(), ',');){
            List<String> fields = reader.readFields();
            long i = 0L;
            while (!fields.isEmpty()) {
                try {
                    this.put(fields.get(0), fields.get(1));
                }
                catch (Exception e) {
                    log.error("Line {}: Unparseable id {} skip gridRecord", (Object)i, (Object)fields.get(1));
                }
                fields = reader.readFields();
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.logWrittenEntries();
    }

    public synchronized void write() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CSVFileWriter writer = new CSVFileWriter(this.file.getPath(), ',');){
            for (Map.Entry entry : this.entrySet()) {
                ArrayList<String> fields = new ArrayList<String>();
                fields.add((String)entry.getKey());
                fields.add((String)entry.getValue());
                writer.writeFields(fields);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.logWrittenEntries();
    }

    public synchronized void append() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CSVFileWriter writer = new CSVFileWriter(this.file.getPath(), ',', true);){
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(this.lastId);
            fields.add((String)this.get(this.lastId));
            writer.writeFields(fields);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.logWrittenEntries();
    }

    @Override
    public String put(String key, String value) {
        this.lastId = key;
        return super.put(key, value);
    }

    private void logWrittenEntries() {
        log.info("Written {} entries", (Object)this.size());
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

