/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.Message;
import com.logicaldoc.core.communication.MessageTemplate;
import com.logicaldoc.core.communication.MessageTemplateDAO;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.communication.SystemMessage;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskException;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveDAO;
import com.logicaldoc.impex.ArchiveManager;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import com.logicaldoc.util.spring.Context;
import com.logicalobjects.jlicense.license.LicenseManager;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="archiveBuilder")
public class ArchiveBuilder
extends Task {
    private static final String NAME = "ArchiveBuilder";
    private long exportCount = 0L;
    private long exported = 0L;
    private long errors = 0L;
    @Resource(name="archiveDAO")
    protected ArchiveDAO archiveDao;
    @Resource(name="folderDAO")
    protected FolderDAO folderDao;
    @Resource(name="documentDAO")
    protected DocumentDAO documentDao;
    @Resource(name="archiveManager")
    protected ArchiveManager archiveManager;
    @Resource(name="messageTemplateDAO")
    protected MessageTemplateDAO messageTemplateDao;
    @Resource(name="Store")
    protected Store store;

    public ArchiveBuilder() {
        super(NAME);
        this.log = LoggerFactory.getLogger(ArchiveBuilder.class);
    }

    public void setArchiveManager(ArchiveManager archiveManager) {
        this.archiveManager = archiveManager;
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    @Override
    protected void runTask() throws TaskException {
        this.log.info("Start building the archives");
        this.exported = 0L;
        this.errors = 0L;
        this.exportCount = 0L;
        try {
            try {
                this.size = this.count();
                this.log.info("Found a total of {} documents to be exported", (Object)this.exportCount);
                this.buildArchives();
            }
            catch (PersistenceException e) {
                throw new TaskException(e);
            }
        }
        finally {
            this.log.info("Build finished");
            this.log.info("Exported documents: {}", (Object)this.exported);
            this.log.info("Errors: {}", (Object)this.errors);
        }
    }

    @Override
    protected String prepareReport(Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(I18N.message("exporteddocs", locale) + ": ");
        sb.append(this.exported);
        sb.append("\n");
        sb.append(I18N.message("errors", locale) + ": ");
        sb.append(this.errors);
        return sb.toString();
    }

    private long count() throws PersistenceException {
        long count = 0L;
        List<Archive> archives = this.archiveDao.findByModeAndStatus(1, 1, null);
        for (Archive archive : archives) {
            long docsCount = this.archiveDao.findArchivedIds(archive.getId()).size();
            count += docsCount;
            this.exportCount += docsCount;
            ++count;
            ++count;
            ++count;
            ++count;
        }
        return count;
    }

    public void buildArchives() throws PersistenceException {
        if (!LicenseManager.getInstance().isEnabled("Feature_4")) {
            this.log.error("Feature not enabled, exit building");
            return;
        }
        this.errors = 0L;
        this.exported = 0L;
        List<Archive> archives = this.archiveDao.findByModeAndStatus(1, 1, null);
        this.log.info("Found {} archives to build", (Object)archives.size());
        for (Archive archive : archives) {
            if (this.interruptRequested) break;
            this.log.info("Process archive '{}'", (Object)archive.getName());
            try {
                this.buildArchive(archive);
                this.log.info("Unlock archive documents");
                this.documentDao.jdbcUpdate("update ld_document set ld_exportstatus=0 where ld_exportstatus=1 and ld_exportid=" + archive.getId());
                if (this.errors == 0L) {
                    this.log.info("Set archive status to 'finalized'");
                    archive.setStatus(2);
                    archive.setSize(FileUtil.getFolderSize(this.archiveManager.getArchiveDirectory(archive)));
                    this.sendMessage(archive);
                    this.sendEmail(archive);
                    this.log.info("Archive closer notified");
                    this.archiveDao.store(archive, false);
                    continue;
                }
                this.log.error("Unable to finalize archive {}, because some errors occurred.", (Object)archive.getName());
                archive.setStatus(4);
                this.archiveDao.store(archive, false);
                this.errors = 0L;
                this.sendMessage(archive);
                this.sendEmail(archive);
                this.log.info("Archive closer notified");
            }
            catch (Exception e) {
                this.log.error("Unable to process archive {}", (Object)archive.getName());
                this.log.error(e.getMessage(), e);
            }
        }
    }

    private void buildArchive(Archive archive) throws PersistenceException {
        File archiveDir = this.archiveManager.getArchiveDirectory(archive);
        archiveDir.mkdirs();
        archiveDir.mkdir();
        this.log.info("Initializing versions collection");
        this.archiveDao.initialize(archive);
        this.next();
        this.log.info("Index file creation");
        File xmlIndexFile = new File(this.archiveManager.getArchiveDirectory(archive), "index.xml");
        File xmlIndexZip = new File(this.archiveManager.getArchiveDirectory(archive), "index.zip");
        File csvIndexFile = new File(this.archiveManager.getArchiveDirectory(archive), "index.csv");
        File csvIndexZip = new File(this.archiveManager.getArchiveDirectory(archive), "index.csv.zip");
        if (!(xmlIndexZip.exists() || xmlIndexFile.exists() || csvIndexZip.exists() || csvIndexFile.exists())) {
            try {
                this.archiveManager.writeIndex(archive);
            }
            catch (Exception e) {
                this.log.error("Unable to write index files", e);
                ++this.errors;
                this.setProgress(this.getProgress() + 1L + (long)archive.getEntries().size());
                return;
            }
        }
        this.next();
        this.log.info("Index file zip");
        try {
            Throwable e = null;
            Object var8_12 = null;
            try (ZipUtil zipUtil = new ZipUtil();){
                File indexZipTmp = new File(this.archiveManager.getArchiveDirectory(archive), "index.zip.tmp");
                zipUtil.zipFile(xmlIndexFile, indexZipTmp);
                FileUtils.moveFile(indexZipTmp, xmlIndexZip);
                FileUtil.delete(xmlIndexFile);
                indexZipTmp = new File(this.archiveManager.getArchiveDirectory(archive), "index.csv.zip.tmp");
                zipUtil.zipFile(csvIndexFile, indexZipTmp);
                FileUtils.moveFile(indexZipTmp, csvIndexZip);
                FileUtil.delete(csvIndexFile);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            this.log.error("Unable to zip the xml index file", e);
            ++this.errors;
            this.setProgress(this.getProgress() + 1L + (long)archive.getEntries().size());
            return;
        }
        this.next();
        if (this.errors == 0L) {
            this.log.info("HTML file creation");
            try {
                FileUtil.copyResource("impex.xsd", new File(this.archiveManager.getArchiveDirectory(archive), "impex.xsd"));
                File indexHtml = new File(this.archiveManager.getArchiveDirectory(archive), "index.html");
                if (!indexHtml.exists()) {
                    this.archiveManager.writeHtmlIndex(archive);
                }
            }
            catch (Exception e) {
                this.log.error("Unable to copy xml files", e);
                ++this.errors;
                this.setProgress(this.getProgress() + 1L + (long)archive.getEntries().size());
                return;
            }
            this.next();
        }
        if (this.errors == 0L) {
            this.copyDocuments(archive);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyDocuments(Archive archive) throws PersistenceException {
        this.log.info("Copy all files");
        Iterator<Version> iterator = archive.getEntries().iterator();
        while (true) {
            block23: {
                if (!iterator.hasNext()) {
                    return;
                }
                Version version = iterator.next();
                if (this.interruptRequested) {
                    return;
                }
                String path = this.folderDao.computePathExtended(version.getFolderId());
                String archiveDocDirPath = "docs" + path;
                File archiveDocDir = new File(this.archiveManager.getArchiveDirectory(archive), archiveDocDirPath);
                archiveDocDir.mkdirs();
                archiveDocDir.mkdir();
                File exportFile = new File(archiveDocDir, version.getFileName());
                if (exportFile.exists()) {
                    this.next();
                    continue;
                }
                String resource = this.store.getResourceName(version.getDocId(), null, null);
                try {
                    try {
                        Throwable throwable = null;
                        Object var10_12 = null;
                        try {
                            InputStream in = this.store.getStream(version.getDocId(), resource);
                            try {
                                try (FileOutputStream out = new FileOutputStream(exportFile);){
                                    byte[] buf = new byte[1024];
                                    while (true) {
                                        int len;
                                        if ((len = in.read(buf)) <= 0) {
                                            out.flush();
                                            ++this.exported;
                                            break;
                                        }
                                        ((OutputStream)out).write(buf, 0, len);
                                    }
                                }
                                if (in == null) break block23;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (in == null) throw throwable;
                                in.close();
                                throw throwable;
                            }
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        this.log.error("Unable to copy file {}", (Object)version.getFileName());
                        this.log.error(e.getMessage(), e);
                        ++this.errors;
                        this.next();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.next();
                    throw throwable;
                }
            }
            this.next();
        }
    }

    protected void prepareMessage(Archive archive, Message message, User user) throws PersistenceException, AutomationException {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        dictionary.put("archive", archive);
        dictionary.put("locale", user.getLocale());
        MessageTemplate template = this.messageTemplateDao.findByNameAndLanguage("impex.arc", user.getLocale().toString(), archive.getTenantId());
        if (template == null) {
            throw new PersistenceException("Unable to find template impex.arc");
        }
        message.setSubject(template.getFormattedSubject(dictionary));
        message.setMessageText(template.getFormattedBody(dictionary));
    }

    private void sendEmail(Archive archive) {
        try {
            User user = (User)this.userDao.findById(archive.getCloserId());
            EMail email = new EMail();
            email.setHtml(1);
            email.setTenantId(user.getTenantId());
            email.setAccountId(-1L);
            email.setAuthor("SYSTEM");
            Recipient recipient = new Recipient();
            recipient.setAddress(user.getEmail());
            recipient.setRead(1);
            email.addRecipient(recipient);
            email.setFolder("outbox");
            email.setSentDate(new Date());
            this.prepareMessage(archive, email, user);
            email.setUsername(user.getUsername());
            EMailSender sender = new EMailSender(user.getTenantId());
            sender.send(email);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), e);
        }
    }

    private void sendMessage(Archive archive) {
        try {
            SystemMessageDAO smdao = Context.get(SystemMessageDAO.class);
            User user = (User)this.userDao.findById(archive.getCloserId());
            Date now = new Date();
            SystemMessage sysmess = new SystemMessage();
            sysmess.setAuthor("SYSTEM");
            Recipient recipient = new Recipient();
            recipient.setName(user.getUsername());
            recipient.setAddress(user.getUsername());
            recipient.setType(0);
            recipient.setMode("TO");
            HashSet<Recipient> recipients = new HashSet<Recipient>();
            recipients.add(recipient);
            recipient.setRead(1);
            sysmess.setRecipients(recipients);
            this.prepareMessage(archive, sysmess, user);
            sysmess.setSentDate(now);
            sysmess.setConfirmation(0);
            sysmess.setPrio(1);
            sysmess.setDateScope(10);
            smdao.store(sysmess);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), e);
        }
    }
}

