/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.document.Version;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="ld_archive")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Archive
extends PersistentObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_OPEN = 0;
    public static final int STATUS_CLOSED = 1;
    public static final int STATUS_FINALIZED = 2;
    public static final int STATUS_READYTOSIGN = 3;
    public static final int STATUS_READY_TO_IMPORT = 0;
    public static final int STATUS_ERROR = 4;
    public static final int TYPE_DEFAULT = 0;
    public static final int MODE_IMPORT = 0;
    public static final int MODE_EXPORT = 1;
    public static final int CUSTOMID_NOT_IMPORT = 0;
    public static final int CUSTOMID_IMPORT_AND_NEW_RELEASE = 1;
    public static final int CUSTOMID_IMPORT_AND_NEW_SUBVERSION = 2;
    public static final int CUSTOMID_IMPORT_AND_NEW_DOCUMENT = 3;
    @Column(name="ld_name", length=255, nullable=false)
    private String name = "";
    @Column(name="ld_description", length=255)
    private String description = "";
    @Column(name="ld_status", nullable=false)
    private int status = 0;
    @Column(name="ld_size", nullable=false)
    private long size = 0L;
    @Column(name="ld_type", nullable=false)
    private int type = 0;
    @Column(name="ld_creatorid", nullable=false)
    private long creatorId;
    @Column(name="ld_creatorname", length=255, nullable=false)
    private String creatorName = "";
    @Column(name="ld_closerid")
    private Long closerId;
    @Column(name="ld_closername", length=255)
    private String closerName = "";
    @Column(name="ld_closure", columnDefinition="DATETIME(3)")
    private Date closure;
    @Column(name="ld_mode", nullable=false)
    private int mode = 0;
    @Column(name="ld_importtemplate", nullable=false)
    private int importTemplate = 1;
    @Column(name="ld_importcustomid", nullable=false)
    private int importCustomId = 0;
    @ManyToMany
    @JoinTable(name="ld_archive_entry", joinColumns={@JoinColumn(name="ld_archiveid")}, inverseJoinColumns={@JoinColumn(name="ld_versionid")})
    @SQLRestriction(value="ld_deleted=0")
    private Set<Version> entries = new HashSet<Version>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<Long> getEntryIds() {
        return this.entries.stream().map(e -> e.getId()).toList();
    }

    public Version getEntry(long versionId) {
        for (Version entry : this.entries) {
            if (entry.getId() != versionId) continue;
            return entry;
        }
        return null;
    }

    public Set<Version> getEntries() {
        return this.entries;
    }

    public void setEntries(Set<Version> entries) {
        this.entries = entries;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean addEntry(Version newVersion) {
        if (this.getEntries().contains(newVersion)) {
            return false;
        }
        this.getEntries().add(newVersion);
        return true;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(long creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Long getCloserId() {
        return this.closerId;
    }

    public void setCloserId(Long closerId) {
        this.closerId = closerId;
    }

    public String getCloserName() {
        return this.closerName;
    }

    public void setCloserName(String closerName) {
        this.closerName = closerName;
    }

    public Date getClosure() {
        return this.closure;
    }

    public void setClosure(Date closure) {
        this.closure = closure;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getImportTemplate() {
        return this.importTemplate;
    }

    public void setImportTemplate(int importTemplate) {
        this.importTemplate = importTemplate;
    }

    public int getImportCustomId() {
        return this.importCustomId;
    }

    public void setImportCustomId(int importCustomId) {
        this.importCustomId = importCustomId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Archive other = (Archive)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

