/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.util.TagUtil;
import com.logicaldoc.util.spring.Context;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexImportHandler
extends IndexHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractIndexImportHandler.class);
    protected Tenant tenant;
    protected Collection<Folder> workspaces;
    protected String importOwner;

    protected void endElementLegacyAttributes(String localName) throws PersistenceException {
        if ("document".equals(localName)) {
            this.endDocumentElement();
        }
        this.readImmutable(localName);
        this.readVersions(localName);
        this.readDates(localName);
        this.readUsers(localName);
        this.readStatus(localName);
        this.readLanguage(localName);
        this.readFileName(localName);
        this.readFileSize(localName);
        this.readColor(localName);
        this.readSigned(localName);
        if ("tags".equals(localName)) {
            this.currentDocument.setTagsFromWords(TagUtil.extractTags(this.tenant.getName(), this.buffer.toString().trim()));
        }
        this.readPublished(localName);
        this.readTemplates(localName);
        this.readExtendedAttributes(localName);
        this.readPathExtended(localName);
    }

    private void readPathExtended(String localName) throws PersistenceException {
        if ("pathextended".equals(localName)) {
            Object pathExtended = this.buffer.toString().trim();
            if (!((String)pathExtended).startsWith("/")) {
                pathExtended = "/" + (String)pathExtended;
            }
            Folder workspace = null;
            for (Folder w : this.workspaces) {
                if (!((String)pathExtended).startsWith("/" + w.getName())) continue;
                workspace = w;
                break;
            }
            if (workspace == null) {
                log.debug("Forcing path {} to /Default {}", pathExtended, pathExtended);
                pathExtended = "/Default" + (String)pathExtended;
            }
            FolderDAO folderDAO = Context.get(FolderDAO.class);
            Folder root = folderDAO.findRoot(this.currentDocument.getTenantId());
            FolderHistory transaction = new FolderHistory();
            UserDAO userDao = Context.get(UserDAO.class);
            User owner = userDao.findByUsername(this.importOwner);
            transaction.setUser(owner);
            Folder docFolder = folderDAO.createPath(root, StringUtils.substringAfter((String)pathExtended, "/"), true, transaction);
            AbstractDocument abstractDocument = this.currentDocument;
            if (abstractDocument instanceof Document) {
                Document dc = (Document)abstractDocument;
                dc.setFolder(docFolder);
            }
        }
    }
}

