/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.i18n;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class I18N {
    private static Map<String, Locale> iso3LocaleMap;
    protected static final String[] bundles;

    static {
        bundles = new String[]{"i18n.messages"};
        String[] languages = Locale.getISOLanguages();
        iso3LocaleMap = new HashMap<String, Locale>();
        String[] stringArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            Locale locale = Locale.of(language);
            iso3LocaleMap.put(locale.getISO3Language().toLowerCase(), locale);
            ++n2;
        }
    }

    private I18N() {
    }

    public static String message(String key) {
        return I18N.message(key, Locale.getDefault());
    }

    public static String message(String key, String language) {
        if (language == null) {
            language = "en";
        }
        return I18N.message(key, Locale.of(language));
    }

    public static String message(String key, Locale locale) {
        String[] stringArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String b = stringArray[n2];
            try {
                String val;
                ResourceBundle bundle = ResourceBundle.getBundle(b, locale);
                if (bundle.containsKey(key) && (val = bundle.getString(key)) != null && !val.isEmpty()) {
                    return val;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return key;
    }

    public static String message(String key, Locale locale, String value1, String value2, String value3) {
        return I18N.message(key, locale, new Object[]{value1, value2, value3});
    }

    public static String message(String key, Locale locale, String value1, String value2) {
        return I18N.message(key, locale, new Object[]{value1, value2});
    }

    public static String message(String key, Locale locale, String value) {
        return I18N.message(key, locale, new Object[]{value});
    }

    public static String message(String key, Locale locale, Object[] values) {
        String msg = I18N.message(key, locale);
        return MessageFormat.format(msg, values);
    }

    public static Map<String, String> getMessages(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String b = stringArray[n2];
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(b, locale);
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String val;
                    String key = keys.nextElement();
                    if (!bundle.containsKey(key) || (val = bundle.getString(key)) == null || val.isEmpty()) continue;
                    map.put(key, bundle.getString(key));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return map;
    }

    public static List<String> getLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        Properties p = new Properties();
        try {
            p.load(I18N.class.getResourceAsStream("/i18n/i18n.properties"));
            StringTokenizer st = new StringTokenizer(p.getProperty("locales"), ",", false);
            while (st.hasMoreTokens()) {
                locales.add(st.nextToken());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return locales;
    }

    public static Locale getLocaleISO3(String iso3Code) {
        return iso3LocaleMap.get(iso3Code.toLowerCase());
    }
}

