/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder.gui;

import com.logicaldoc.hotfolder.gui.Daemon;
import com.logicaldoc.hotfolder.gui.I18N;
import com.logicaldoc.hotfolder.gui.Main;
import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Tray {
    public static void main(final String[] args) throws IOException, InterruptedException {
        final String servicePath = args.length > 0 ? args[0] : System.getProperty("user.dir");
        final BufferedImage imageStart = ImageIO.read(ClassLoader.getSystemResource("images/app16.png"));
        final BufferedImage imageStop = ImageIO.read(ClassLoader.getSystemResource("images/app16gray.png"));
        SystemTray tray = SystemTray.getSystemTray();
        PopupMenu popup = new PopupMenu();
        MenuItem startItem = new MenuItem(I18N.message("start"));
        startItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Daemon(servicePath).start();
            }
        });
        popup.add(startItem);
        MenuItem stopItem = new MenuItem(I18N.message("stop"));
        stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Daemon(servicePath).stop();
            }
        });
        popup.add(stopItem);
        MenuItem settingsItem = new MenuItem(I18N.message("settings"));
        settingsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.main(args);
            }
        });
        popup.add(settingsItem);
        MenuItem exitItem = new MenuItem(I18N.message("exit"));
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        popup.add(exitItem);
        final TrayIcon trayIcon = new TrayIcon(imageStart, "LogicalDOC Hot Folder", popup);
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e) {
            System.err.println(e);
        }
        Thread statusChecker = new Thread(){

            @Override
            public void run() {
                File pidFile = new File(servicePath + "/pid");
                while (true) {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (pidFile.exists()) {
                        trayIcon.setImage(imageStart);
                        continue;
                    }
                    trayIcon.setImage(imageStop);
                }
            }
        };
        statusChecker.start();
    }

    public static boolean isWindows() {
        boolean windows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
        return windows;
    }
}

