/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder.gui;

import java.awt.event.ActionEvent;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public abstract class LazyLoadingTreeNode
extends DefaultMutableTreeNode
implements TreeWillExpandListener {
    private static final String ESCAPE_ACTION_NAME = "escape";
    private static final KeyStroke ESCAPE_KEY = KeyStroke.getKeyStroke(27, 0);
    protected JTree tree;
    private boolean cancelable;

    public LazyLoadingTreeNode(Object userObject, JTree tree, boolean cancelable) {
        super(userObject);
        tree.addTreeWillExpandListener(this);
        this.tree = tree;
        this.cancelable = cancelable;
        this.setAllowsChildren(true);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    void setLoading() {
        this.setChildren(this.createLoadingNode());
        TreeModel model = this.tree.getModel();
        if (model instanceof DefaultTreeModel) {
            DefaultTreeModel defaultModel = (DefaultTreeModel)model;
            int[] indices = new int[this.getChildCount()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
            defaultModel.nodesWereInserted(this, indices);
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        if (this.equals(event.getPath().getLastPathComponent())) {
            if (this.areChildrenLoaded()) {
                return;
            }
            this.setLoading();
            SwingWorker<MutableTreeNode[], ?> worker = this.createSwingWorker(this.tree, this.cancelable);
            worker.execute();
        }
    }

    protected void setChildren(MutableTreeNode ... nodes) {
        TreeModel model;
        if (nodes == null) {
            // empty if block
        }
        if ((model = this.tree.getModel()) instanceof DefaultTreeModel) {
            int i;
            DefaultTreeModel defaultModel = (DefaultTreeModel)model;
            int childCount = this.getChildCount();
            if (childCount > 0) {
                for (i = 0; i < childCount; ++i) {
                    defaultModel.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
                }
            }
            for (i = 0; i < nodes.length; ++i) {
                defaultModel.insertNodeInto(nodes[i], this, i);
            }
        }
    }

    protected SwingWorker<MutableTreeNode[], ?> createSwingWorker(final JTree tree, boolean cancelable) {
        SwingWorker<MutableTreeNode[], Object> worker = new SwingWorker<MutableTreeNode[], Object>(){

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        MutableTreeNode[] nodes = (MutableTreeNode[])this.get();
                        LazyLoadingTreeNode.this.setAllowsChildren(nodes.length > 0);
                        LazyLoadingTreeNode.this.setChildren(nodes);
                        LazyLoadingTreeNode.this.unRegisterSwingWorkerForCancel(tree, this);
                    } else {
                        LazyLoadingTreeNode.this.reset();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected MutableTreeNode[] doInBackground() throws Exception {
                return LazyLoadingTreeNode.this.loadChildren(tree);
            }
        };
        this.registerSwingWorkerForCancel(tree, worker);
        return worker;
    }

    protected void registerSwingWorkerForCancel(JTree tree, SwingWorker<MutableTreeNode[], ?> worker) {
        if (!this.cancelable) {
            return;
        }
        tree.getInputMap().put(ESCAPE_KEY, ESCAPE_ACTION_NAME);
        Action action = tree.getActionMap().get(ESCAPE_ACTION_NAME);
        if (action == null) {
            CancelWorkersAction cancelWorkerAction = new CancelWorkersAction();
            cancelWorkerAction.addSwingWorker(worker);
            tree.getActionMap().put(ESCAPE_ACTION_NAME, cancelWorkerAction);
        } else if (action instanceof CancelWorkersAction) {
            CancelWorkersAction cancelAction = (CancelWorkersAction)action;
            cancelAction.addSwingWorker(worker);
        }
    }

    protected void unRegisterSwingWorkerForCancel(JTree tree, SwingWorker<MutableTreeNode[], ?> worker) {
        if (!this.cancelable) {
            return;
        }
        Action action = tree.getActionMap().get(ESCAPE_ACTION_NAME);
        if (action != null && action instanceof CancelWorkersAction) {
            CancelWorkersAction cancelWorkerAction = new CancelWorkersAction();
            cancelWorkerAction.removeSwingWorker(worker);
        }
    }

    protected void reset() {
        DefaultTreeModel defaultModel = (DefaultTreeModel)this.tree.getModel();
        int childCount = this.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                defaultModel.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
        }
        this.setAllowsChildren(true);
    }

    protected boolean areChildrenLoaded() {
        return this.getChildCount() > 0 && this.getAllowsChildren();
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren();
    }

    public abstract MutableTreeNode[] loadChildren(JTree var1);

    protected MutableTreeNode createLoadingNode() {
        return new DefaultMutableTreeNode("Loading Please Wait ...", false);
    }

    protected static class CancelWorkersAction
    extends AbstractAction {
        private Vector<SwingWorker<MutableTreeNode[], ?>> workers = new Vector();

        private CancelWorkersAction() {
            super(LazyLoadingTreeNode.ESCAPE_ACTION_NAME);
        }

        public void addSwingWorker(SwingWorker<MutableTreeNode[], ?> worker) {
            this.workers.add(worker);
        }

        public void removeSwingWorker(SwingWorker<MutableTreeNode[], ?> worker) {
            this.workers.remove(worker);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SwingWorker<MutableTreeNode[], ?> worker : this.workers) {
                worker.cancel(true);
            }
        }
    }
}

