/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder.gui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class I18N {
    private I18N() {
    }

    public static String message(String key) {
        return I18N.message(key, Locale.getDefault());
    }

    public static String message(String key, String lang) {
        return I18N.message(key, new Locale(lang));
    }

    public static String message(String key, Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("i18n.messages", locale);
            return bundle.getString(key);
        }
        catch (Throwable throwable) {
            return key;
        }
    }

    public static String message(String key, Locale locale, String value) {
        return I18N.message(key, locale, new Object[]{value});
    }

    public static String message(String key, Locale locale, Object[] values) {
        String msg = I18N.message(key, locale);
        return MessageFormat.format(msg, values);
    }

    public static String message(String key, Object[] values) {
        String msg = I18N.message(key);
        return MessageFormat.format(msg, values);
    }

    public static List<String> getLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        Properties p = new Properties();
        try {
            p.load(I18N.class.getResourceAsStream("/i18n/i18n.properties"));
            StringTokenizer st = new StringTokenizer(p.getProperty("locales"), ",", false);
            while (st.hasMoreTokens()) {
                locales.add(st.nextToken());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return locales;
    }
}

