/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder.gui;

import com.logicaldoc.hotfolder.gui.LazyLoadingTreeNode;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.soap.client.SoapFolderClient;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;

public class FolderTreeNode
extends LazyLoadingTreeNode {
    private static final long serialVersionUID = 1L;
    private SoapFolderClient client;
    private String sid;

    public FolderTreeNode(WSFolder folder, String sid, JTree tree) {
        super(folder, tree, true);
        this.sid = sid;
        try {
            ContextProperties config = new ContextProperties();
            this.client = new SoapFolderClient(config.getProperty("url") + "/services/Folder");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public MutableTreeNode[] loadChildren(JTree tree) {
        WSFolder parent = (WSFolder)this.getUserObject();
        List<WSFolder> children = null;
        try {
            children = this.client.listChildren(this.sid, parent.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (children == null) {
            children = new ArrayList<WSFolder>();
        }
        MutableTreeNode[] nodes = new MutableTreeNode[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            WSFolder f = children.get(i);
            nodes[i] = new FolderTreeNode(f, this.sid, tree);
        }
        return nodes.length > 0 ? nodes : null;
    }

    @Override
    public String toString() {
        WSFolder folder = (WSFolder)this.getUserObject();
        Object name = folder.getName();
        if (folder.getType() == 1) {
            name = "[" + (String)name + "]";
        }
        return name;
    }

    @Override
    public boolean getAllowsChildren() {
        WSFolder parent = (WSFolder)this.getUserObject();
        List<WSFolder> children = null;
        try {
            children = this.client.listChildren(this.sid, parent.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return children != null && children.size() > 0;
    }

    public WSFolder getFolder() {
        return (WSFolder)this.getUserObject();
    }
}

