/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder.gui;

import com.logicaldoc.hotfolder.gui.ConfigForm;
import com.logicaldoc.hotfolder.gui.FolderTreeNode;
import com.logicaldoc.hotfolder.gui.I18N;
import com.logicaldoc.hotfolder.gui.Main;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.soap.client.SoapAuthClient;
import com.logicaldoc.webservice.soap.client.SoapFolderClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderChooser
extends JFrame {
    private SoapFolderClient fClient;
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(FolderChooser.class);
    private String sid;
    private SoapAuthClient auth;
    private JTree tree;
    private ConfigForm configForm = null;

    public FolderChooser(ConfigForm configForm) {
        this.configForm = configForm;
        this.setLocationRelativeTo(null);
        ImageIcon icon = new ImageIcon(Main.class.getResource("/images/app32.png"));
        this.setIconImage(icon.getImage());
        this.setDefaultCloseOperation(2);
        try {
            ContextProperties config = new ContextProperties();
            this.fClient = new SoapFolderClient(config.getProperty("url") + "/services/Folder");
            this.auth = new SoapAuthClient(config.getProperty("url") + "/services/Auth");
            this.sid = this.auth.loginApiKey(config.getProperty("apikey"));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        if (this.sid == null) {
            JOptionPane.showMessageDialog(null, I18N.message("connectionfailed"), I18N.message("error"), 0);
            WindowEvent wev = new WindowEvent(this, 201);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
            return;
        }
        this.initGUI();
        this.tree.setSelectionRow(0);
        TreePath path = this.tree.getSelectionPath();
        FolderTreeNode root = (FolderTreeNode)this.tree.getModel().getRoot();
        TreeExpansionEvent event = new TreeExpansionEvent(root, path);
        try {
            root.treeWillExpand(event);
        }
        catch (ExpandVetoException e) {
            e.printStackTrace();
        }
    }

    public void logout() {
        if (this.sid != null) {
            this.auth.logout(this.sid);
        }
        this.sid = null;
    }

    @Override
    public void dispose() {
        this.logout();
        super.dispose();
    }

    private void initGUI() {
        try {
            this.setSize(400, 400);
            this.tree = new JTree();
            this.tree.setPreferredSize(null);
            WSFolder root = new WSFolder();
            root.setName("/           ");
            root.setId(5L);
            this.tree.setModel(new DefaultTreeModel(new FolderTreeNode(root, this.sid, this.tree)));
            JScrollPane scroll = new JScrollPane();
            scroll.setViewportView(this.tree);
            scroll.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)scroll, "Center");
            JButton select = new JButton(I18N.message("select"));
            select.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FolderChooser.this.onSelect();
                }
            });
            this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (!(value instanceof FolderTreeNode)) {
                        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    }
                    WSFolder folder = ((FolderTreeNode)value).getFolder();
                    String name = folder.getName();
                    JLabel label = new JLabel(name);
                    if (selected) {
                        label.setForeground(Color.BLUE);
                    }
                    if (folder.getId() == 5L || folder.getType() == 1) {
                        label.setIcon(new ImageIcon(this.getClass().getResource("/images/cube_blue16.png")));
                    } else {
                        label.setIcon(new ImageIcon(this.getClass().getResource("/images/folder_closed.png")));
                    }
                    return label;
                }
            });
            JButton rename = new JButton(I18N.message("rename"));
            rename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FolderChooser.this.onRename();
                }
            });
            JButton create = new JButton(I18N.message("create"));
            create.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FolderChooser.this.onCreate();
                }
            });
            JButton delete = new JButton(I18N.message("delete"));
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FolderChooser.this.onDelete();
                }
            });
            JPanel buttons = new JPanel();
            buttons.add(select);
            buttons.add(rename);
            buttons.add(create);
            buttons.add(delete);
            this.getContentPane().add((Component)buttons, "South");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onSelect() {
        if (this.tree.isSelectionEmpty()) {
            return;
        }
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        WSFolder folder = (WSFolder)selectedNode.getUserObject();
        if (folder.getId() == 5L) {
            return;
        }
        Object[] xxx = path.getPath();
        Object pathString = "";
        for (int i = 0; i < xxx.length; ++i) {
            if (!((String)pathString).endsWith("/")) {
                pathString = (String)pathString + "/";
            }
            pathString = (String)pathString + ((FolderTreeNode)xxx[i]).getFolder().getName().trim();
        }
        try {
            this.configForm.setTargetFolder((String)pathString, folder.getId());
            WindowEvent wev = new WindowEvent(this, 201);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    private void onRename() {
        if (this.tree.isSelectionEmpty()) {
            return;
        }
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        WSFolder folder = (WSFolder)selectedNode.getUserObject();
        if (folder.getId() == 5L || folder.getType() != 0) {
            return;
        }
        String name = JOptionPane.showInputDialog(null, I18N.message("name"), folder.getName());
        if (StringUtils.isNotEmpty(name = name.trim().replaceAll("/", ""))) {
            try {
                this.fClient.rename(this.sid, folder.getId(), name);
                folder.setName(name);
                selectedNode.setUserObject(folder);
                this.tree.repaint();
            }
            catch (Throwable e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, I18N.message("errot"), I18N.message("error"), 0);
            }
        }
    }

    private void onCreate() {
        if (this.tree.isSelectionEmpty()) {
            return;
        }
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        WSFolder parent = (WSFolder)selectedNode.getUserObject();
        if (parent.getId() == 5L) {
            return;
        }
        String name = JOptionPane.showInputDialog(null, I18N.message("name"), "");
        if (StringUtils.isEmpty(name = name.trim().replaceAll("/", ""))) {
            return;
        }
        if (StringUtils.isNotEmpty(name)) {
            try {
                WSFolder folder = new WSFolder();
                folder.setName(name);
                folder.setParentId(parent.getId());
                folder = this.fClient.create(this.sid, folder);
                FolderTreeNode newnode = new FolderTreeNode(folder, this.sid, this.tree);
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                model.insertNodeInto(newnode, selectedNode, selectedNode.getChildCount());
                this.tree.repaint();
            }
            catch (Throwable e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, I18N.message("error"), I18N.message("error"), 0);
            }
        }
    }

    private void onDelete() {
        if (this.tree.isSelectionEmpty()) {
            return;
        }
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        WSFolder folder = (WSFolder)selectedNode.getUserObject();
        if (folder.getId() == 5L || folder.getType() != 0) {
            return;
        }
        int answer = JOptionPane.showConfirmDialog(this, I18N.message("confirmdelete"));
        if (answer == 0) {
            try {
                this.fClient.delete(this.sid, folder.getId());
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                model.removeNodeFromParent(selectedNode);
                this.tree.repaint();
            }
            catch (Throwable e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, I18N.message("error"), I18N.message("error"), 0);
            }
        }
    }
}

