/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder.gui;

import com.logicaldoc.hotfolder.gui.I18N;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.webservice.soap.client.SoapAuthClient;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectForm
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField apiKey;
    private JLabel apiKeyLabel;
    private JLabel urlLabel;
    private JButton connect;
    private JTextField url;
    private static final Logger log = LoggerFactory.getLogger(ConnectForm.class);

    public ConnectForm() {
        this.initGUI();
        this.apiKeyLabel.setText(I18N.message("apikey") + ": ");
        this.urlLabel.setText(I18N.message("url") + ": ");
        this.connect.setText(I18N.message("connect"));
        try {
            ContextProperties config = new ContextProperties();
            this.url.setText(config.getProperty("url"));
            this.apiKey.setText(config.getProperty("apikey"));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            thisLayout.rowHeights = new int[]{7, 7, 7, 7};
            thisLayout.columnWeights = new double[]{0.0, 0.1};
            thisLayout.columnWidths = new int[]{115, 7};
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(477, 179));
            this.url = new JTextField();
            this.add((Component)this.url, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.url.setPreferredSize(new Dimension(82, 23));
            this.apiKeyLabel = new JLabel();
            this.add((Component)this.apiKeyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.apiKeyLabel.setName("passwordLabel");
            this.apiKey = new JTextField();
            this.add((Component)this.apiKey, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.apiKey.setPreferredSize(new Dimension(82, 23));
            this.urlLabel = new JLabel();
            this.add((Component)this.urlLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.urlLabel.setName("urlLabel");
            this.connect = new JButton();
            this.add((Component)this.connect, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.connect.setName("connect");
            this.connect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConnectForm.this.onConnect(evt);
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnect(ActionEvent evt) {
        try {
            ContextProperties config = new ContextProperties();
            SoapAuthClient client = new SoapAuthClient(this.url.getText().trim() + "/services/Auth");
            String sid = null;
            try {
                sid = client.loginApiKey(new String(this.apiKey.getText().trim()));
                if (sid != null) {
                    client.logout(sid);
                }
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    if (sid != null) {
                        client.logout(sid);
                    }
                }
                catch (Throwable throwable) {
                    if (sid != null) {
                        client.logout(sid);
                    }
                    throw throwable;
                }
            }
            if (sid != null) {
                config.setProperty("url", this.url.getText().trim());
                config.setProperty("apikey", this.apiKey.getText().trim());
                config.write();
                JOptionPane.showMessageDialog(null, I18N.message("connectionestablished"), I18N.message("info"), 1);
            } else {
                JOptionPane.showMessageDialog(null, I18N.message("connectionfailed"), I18N.message("error"), 0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

