/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder.gui;

import com.logicaldoc.hotfolder.gui.FolderChooser;
import com.logicaldoc.hotfolder.gui.I18N;
import com.logicaldoc.util.config.ContextProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class ConfigForm
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel targetLabel;
    private JButton save;
    private JComboBox lang;
    private JLabel langLabel;
    private JLabel filterLabel;
    private JTextField filter;
    private JButton chooseFolder;
    private JButton chooseDir;
    private JTextField source;
    private JLabel sourceLabel;
    private JTextField target;
    private long targetId = 4L;
    private JTextField batch;
    private JLabel batchLabel;
    private JTextField frequency;
    private JLabel freqLabel;

    public ConfigForm() {
        this.initGUI();
        Locale[] locales = new Locale[]{Locale.ENGLISH, Locale.ITALIAN, new Locale("es"), Locale.GERMAN, Locale.FRENCH};
        DefaultComboBoxModel<Locale> langModel = new DefaultComboBoxModel<Locale>(locales);
        this.lang.setModel(langModel);
        this.lang.setRenderer(new ListCellRenderer<Locale>(this){

            @Override
            public Component getListCellRendererComponent(JList<? extends Locale> list, Locale value, int index, boolean isSelected, boolean cellHasFocus) {
                return new JLabel(value.getDisplayName());
            }
        });
        this.sourceLabel.setText(I18N.message("watch") + ": ");
        this.targetLabel.setText(I18N.message("uploadto") + ": ");
        this.chooseDir.setText(I18N.message("select") + "...");
        this.chooseFolder.setText(I18N.message("select") + "...");
        this.filterLabel.setText(I18N.message("filter") + ": ");
        this.langLabel.setText(I18N.message("language") + ": ");
        this.freqLabel.setText(I18N.message("frequency") + " (" + I18N.message("minutes").toLowerCase() + "): ");
        this.batchLabel.setText(I18N.message("batch") + ": ");
        this.save.setText(I18N.message("save"));
        try {
            ContextProperties config = new ContextProperties();
            this.source.setText(config.getProperty("folder.0.path"));
            this.target.setText(config.getProperty("folder.0.target.name"));
            this.filter.setText(config.getProperty("folder.0.includes"));
            this.frequency.setText("" + config.getInt("schedule.interval.HotFolderCrawler") / 1000 / 60);
            this.batch.setText(config.getProperty("folder.0.batch"));
            String language = config.getProperty("folder.0.locale");
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                if (!locale.toString().equals(language)) continue;
                this.lang.setSelectedIndex(i);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setPreferredSize(new Dimension(453, 253));
            thisLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            thisLayout.rowHeights = new int[]{7, 7, 7, 7, 20, 20, 20};
            thisLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            thisLayout.columnWidths = new int[]{170, 193, 20};
            this.setLayout(thisLayout);
            this.targetLabel = new JLabel();
            this.add((Component)this.targetLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.targetLabel.setName("targetLabel");
            this.target = new JTextField();
            this.add((Component)this.target, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.sourceLabel = new JLabel();
            this.add((Component)this.sourceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.sourceLabel.setName("sourceLabel");
            this.source = new JTextField();
            this.add((Component)this.source, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.chooseDir = new JButton();
            this.add((Component)this.chooseDir, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.chooseDir.setName("chooseDir");
            this.chooseDir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConfigForm.this.onChooseDir(evt);
                }
            });
            this.chooseFolder = new JButton();
            this.add((Component)this.chooseFolder, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.chooseFolder.setName("chooseFolder");
            this.chooseFolder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConfigForm.this.onChooseFolder(evt);
                }
            });
            this.filter = new JTextField();
            this.add((Component)this.filter, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.filterLabel = new JLabel();
            this.add((Component)this.filterLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.filterLabel.setName("filterLabel");
            this.langLabel = new JLabel();
            this.add((Component)this.langLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.langLabel.setName("langLabel");
            DefaultComboBoxModel<String> langModel = new DefaultComboBoxModel<String>(new String[]{"Item One", "Item Two"});
            this.lang = new JComboBox();
            this.add((Component)this.lang, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lang.setModel(langModel);
            this.save = new JButton();
            this.add((Component)this.save, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.save.setName("save");
            this.save.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConfigForm.this.onSave(evt);
                }
            });
            this.freqLabel = new JLabel();
            this.add((Component)this.freqLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.freqLabel.setText(I18N.message("frequency") + " (" + I18N.message("minutes").toLowerCase() + "): ");
            this.freqLabel.setName("intervalLabel");
            this.frequency = new JTextField();
            this.add((Component)this.frequency, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.frequency.setPreferredSize(new Dimension(100, 23));
            this.frequency.setSize(23, 100);
            this.batchLabel = new JLabel();
            this.add((Component)this.batchLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.batchLabel.setText(I18N.message("batch") + ": ");
            this.batchLabel.setName("batchLabel");
            this.batch = new JTextField();
            this.add((Component)this.batch, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.batch.setPreferredSize(new Dimension(100, 23));
            this.batch.setSize(23, 100);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onChooseDir(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(null) == 0) {
            this.source.setText(chooser.getSelectedFile().getAbsolutePath());
            try {
                ContextProperties config = new ContextProperties();
                config.setProperty("folder.0.path", this.source.getText().trim());
                config.write();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void setTargetFolder(String name, long id) {
        this.target.setText(name);
        this.targetId = id;
    }

    private void onChooseFolder(ActionEvent evt) {
        FolderChooser chooser = new FolderChooser(this);
        chooser.setVisible(true);
    }

    private void onSave(ActionEvent evt) {
        try {
            ContextProperties config = new ContextProperties();
            config.setProperty("folder.0.path", this.source.getText().trim());
            config.setProperty("folder.0.target", Long.toString(this.targetId));
            config.setProperty("folder.0.target.name", this.target.getText().trim());
            config.setProperty("folder.0.includes", this.filter.getText().trim());
            config.setProperty("folder.0.locale", this.lang.getSelectedItem().toString());
            try {
                config.setProperty("schedule.interval.HotFolderCrawler", "" + Integer.parseInt(this.frequency.getText().trim()) * 1000 * 60);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                config.setProperty("folder.0.batch", "" + Integer.parseInt(this.batch.getText().trim()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            config.write();
            JOptionPane.showMessageDialog(null, I18N.message("settingssaved"), I18N.message("info"), 1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, I18N.message("genericerror"), I18N.message("error"), 0);
        }
    }
}

