/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder;

import com.logicaldoc.hotfolder.CrawlerHelper;
import com.logicaldoc.hotfolder.DMS;
import com.logicaldoc.hotfolder.HotFolderCrawler;
import com.logicaldoc.hotfolder.HotFolderIndexHandler;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.impex.IndexHeaderHandler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.util.TagUtil;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.model.WSTemplate;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHelper
extends CrawlerHelper {
    private static final Logger log = LoggerFactory.getLogger(LocalHelper.class);

    protected LocalHelper(ImportFolder importFolder) {
        super(importFolder, DMS.get().getSid());
    }

    @Override
    public void checkinFile(Object file, long docId) throws Exception {
        File localFile = (File)file;
        DMS.get().uploadNewRevision(docId, localFile, "Hot Folders upload");
        log.info("Updated document from file {}", (Object)localFile.getPath());
    }

    @Override
    public WSDocument importFile(Object file, long folderId) throws Exception {
        File localFile = (File)file;
        Set<String> tags = null;
        if (StringUtils.isNotEmpty(this.importFolder.getTags())) {
            tags = TagUtil.extractTags("default", this.importFolder.getTags());
        }
        WSDocument doc = new WSDocument();
        doc.setFileName(localFile.getName());
        doc.setFolderId(folderId);
        doc.setCreation(LocalHelper.convertDateToString(this.getCreationDate(file)));
        doc.setLanguage(this.importFolder.getLanguage());
        doc.setTemplateId(this.importFolder.getTemplateId());
        doc.setComment("Hot Folders upload");
        doc.setIndexed(0);
        if (tags != null) {
            doc.setTags(List.copyOf(tags));
        }
        doc = DMS.get().createDocument(doc, localFile);
        log.info("Imported new document from file {}", (Object)localFile.getPath());
        return doc;
    }

    private static String convertDateToString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        try {
            return df.format(date);
        }
        catch (Exception e) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            return df.format(date);
        }
    }

    @Override
    public void list(Object parent, int depth, List<Object> files, long max, ImportFolderCache cache) throws Exception {
        if (max > 0L && (long)files.size() >= max) {
            return;
        }
        File parentDir = null;
        parentDir = parent == null ? new File(this.importFolder.getUrl().substring("file://".length())) : (File)parent;
        log.info("Listing parent folder {}", (Object)parentDir.getAbsolutePath());
        File[] filesArray = null;
        try {
            filesArray = parentDir.listFiles(new HotFolderFilter(this.importFolder));
        }
        catch (Exception e) {
            log.error("Access denied on {}", (Object)parentDir.getPath());
            return;
        }
        if (filesArray != null) {
            log.info("Found {} files in {}", (Object)filesArray.length, (Object)parentDir.getAbsolutePath());
            int i = 0;
            while (i < filesArray.length) {
                if (filesArray[i].isDirectory() && depth >= 1) {
                    try {
                        this.list(filesArray[i], depth - 1, files, max, cache);
                    }
                    catch (Exception e) {
                        log.error("Access denied on {}", (Object)parentDir.getPath());
                        return;
                    }
                }
                if (filesArray[i].isFile()) {
                    if ((long)files.size() >= max) break;
                    if (this.toBeImported(filesArray[i], cache)) {
                        files.add(filesArray[i]);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public String getPath(Object file) throws Exception {
        File localFile = (File)file;
        File root = new File(this.importFolder.getUrl().substring("file://".length()));
        String path = localFile.getPath().substring(root.getPath().length());
        return path.replaceAll("\\\\", "/");
    }

    @Override
    public Date getLastModified(Object file) {
        return new Date(((File)file).lastModified());
    }

    @Override
    public Date getCreationDate(Object file) {
        try {
            File localFile = (File)file;
            Path p = Paths.get(localFile.getAbsolutePath(), new String[0]);
            BasicFileAttributes view = Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            return new Date(view.creationTime().toMillis());
        }
        catch (Throwable t) {
            return this.getLastModified(file);
        }
    }

    @Override
    public boolean importUsingIndex(HotFolderCrawler shareCrawler, WSFolder folder) throws Exception {
        File indexFile = new File(this.importFolder.getPath(), "index.xml");
        if (!indexFile.exists()) {
            return false;
        }
        log.debug("Analyzing index file: {}", (Object)indexFile.getName());
        List<WSTemplate> allTemplates = DMS.get().listTemplates();
        HashMap<String, WSTemplate> templates = new HashMap<String, WSTemplate>();
        for (WSTemplate template : allTemplates) {
            templates.put(template.getName(), template);
        }
        HotFolderIndexHandler handler = new HotFolderIndexHandler(this.importFolder, shareCrawler, folder.getId(), templates);
        new Index(indexFile, (IndexHandler)handler);
        return true;
    }

    @Override
    public int importDocumentsCount() throws Exception {
        File indexFile = new File(this.importFolder.getPath(), "index.xml");
        if (!indexFile.exists()) {
            return 0;
        }
        IndexHeaderHandler handler = new IndexHeaderHandler();
        Index index = new Index(indexFile, (IndexHandler)handler);
        return (int)index.getCount();
    }

    @Override
    public boolean deleteFile(Object file) {
        File localFile = (File)file;
        try {
            FileUtils.forceDelete(localFile);
            return !localFile.exists();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private class HotFolderFilter
    implements FileFilter {
        private ImportFolder importFolder;

        public HotFolderFilter(ImportFolder importFolder) {
            this.importFolder = importFolder;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            boolean accepted = this.importFolder.isAllowed(file.getName());
            log.debug("File {} allowed: {}", (Object)file.getAbsolutePath(), (Object)accepted);
            if (this.importFolder.getMaxSize() != null && this.importFolder.getMaxSize() > 0 && file.length() > (long)this.importFolder.getMaxSize().intValue()) {
                accepted = false;
                log.debug("File {} over allowed size {} bytes", (Object)file.getAbsolutePath(), (Object)this.importFolder.getMaxSize());
            }
            if (this.importFolder.getStartDate() != null && this.importFolder.getStartDate().after(new Date(file.lastModified()))) {
                accepted = false;
                log.debug("File {} older than {}", (Object)file.getAbsolutePath(), (Object)this.importFolder.getStartDate());
            }
            log.info("accept {} {}", (Object)file.getAbsolutePath(), (Object)accepted);
            return accepted;
        }
    }
}

