/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder;

import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.hotfolder.DMS;
import com.logicaldoc.hotfolder.HotFolderCrawler;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderCacheManager;
import com.logicaldoc.util.TagUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.model.WSAttribute;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSTemplate;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HotFolderIndexHandler
extends IndexHandler {
    protected HotFolderCrawler crawler;
    protected WSDocument currentDocument;
    protected StringBuilder buffer = new StringBuilder();
    protected String currentAttributeName;
    protected String currentWSAttributeMandatory;
    protected String currentWSAttributeHidden;
    protected String currentWSAttributePosition;
    protected String currentWSAttributeType;
    protected String currentWSAttributeLabel;
    protected String currentPathExtended;
    protected Map<String, WSTemplate> templates;
    protected Map<Long, WSTemplate> templatesIds;
    protected long targetFolder;
    protected ImportFolder importFolder;
    protected File docFile;
    private long currentFolder;
    private String currentPath;
    private static final Logger log = LoggerFactory.getLogger(HotFolderIndexHandler.class);

    public HotFolderIndexHandler(ImportFolder importFolder, HotFolderCrawler crawler, long targetFolder, Map<String, WSTemplate> templates) {
        this.importFolder = importFolder;
        this.crawler = crawler;
        this.templates = templates;
        this.templatesIds = new HashMap<Long, WSTemplate>();
        this.targetFolder = targetFolder;
        for (String name : templates.keySet()) {
            WSTemplate template = templates.get(name);
            this.templatesIds.put(template.getId(), template);
        }
    }

    @Override
    public void startElement(String uri, String localname, String tagName, Attributes attributes) throws SAXException {
        if (localname.equalsIgnoreCase("document")) {
            this.currentDocument = new WSDocument();
            this.currentAttributeName = "";
            this.currentWSAttributeMandatory = "";
            this.currentWSAttributePosition = "";
            this.currentWSAttributeType = "";
            this.currentWSAttributeLabel = "";
            this.currentPathExtended = "";
            if (attributes.getLength() != 0) {
                this.setDocumentAttributes(attributes);
            }
        }
    }

    private void setDocumentAttributes(Attributes attributes) {
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            if (!attributes.getQName(i).equals("customid")) continue;
            this.currentDocument.setCustomId(attributes.getValue(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endDocumentElement() {
        ImportFolderCache cache = Context.get(ImportFolderCacheManager.class).getCache(this.importFolder.getId());
        boolean fileFound = true;
        try {
            log.debug("Inspecting document {}", (Object)this.currentDocument.getFileName());
            if (this.docFile == null || !this.docFile.exists()) {
                log.debug("Unable to find the file for document {}", (Object)this.currentDocument.getFileName());
                fileFound = false;
                return;
            }
            if (cache.get(this.currentPath) != null) {
                long originalFileTimeMillis;
                ImportFolderCache.CacheEntry entry = cache.get(this.currentPath);
                Date lastImported = entry.getDate();
                if (lastImported.compareTo(new Date(originalFileTimeMillis = this.docFile.lastModified())) < 0) {
                    WSDocument document = DMS.get().getDocument(entry.getDocId());
                    try {
                        if (document != null) {
                            DMS.get().uploadNewRevision(document.getId(), this.docFile, "");
                            DocumentHistory transaction = new DocumentHistory();
                            transaction.setEvent(DocumentEvent.STORED.toString());
                            transaction.setDocId(document.getId());
                            this.crawler.afterDocumentImported(this.importFolder, transaction);
                        } else {
                            this.updateTemplate(this.currentDocument);
                            WSDocument doc = new WSDocument();
                            doc.setFileName(this.docFile.getName());
                            doc.setFolderId(this.currentFolder);
                            doc.setLanguage(this.currentDocument.getLanguage());
                            doc.setTags(this.currentDocument.getTags());
                            doc.setTemplateId(this.currentDocument.getTemplateId());
                            doc.setAttributes(this.currentDocument.getAttributes());
                            doc.setCustomId(this.currentDocument.getCustomId());
                            if (this.currentDocument.getImmutable() >= 0) {
                                doc.setImmutable(this.currentDocument.getImmutable());
                            }
                            if (this.currentDocument.getDate() != null) {
                                doc.setDate(this.currentDocument.getDate());
                            }
                            doc.setPublished(this.currentDocument.getPublished());
                            doc.setStartPublishing(this.currentDocument.getStartPublishing());
                            doc.setStopPublishing(this.currentDocument.getStopPublishing());
                            WSDocument wsdoc = DMS.get().createDocument(doc, this.docFile);
                            DocumentHistory transaction = new DocumentHistory();
                            transaction.setEvent(DocumentEvent.STORED.toString());
                            transaction.setDocId(wsdoc.getId());
                            transaction.setFolderId(this.currentFolder);
                            transaction.setFilename(this.docFile.getName());
                            this.crawler.afterDocumentImported(this.importFolder, transaction);
                            document = doc;
                        }
                        cache.put(new ImportFolderCache.CacheEntry(this.currentPath, new Date(), document.getId()));
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        this.crawler.onError(this.importFolder, null, this.currentPath, e);
                        log.error("Error importing " + this.currentPath, e);
                    }
                }
            } else {
                try {
                    this.updateTemplate(this.currentDocument);
                    WSDocument doc = new WSDocument();
                    doc.setFileName(this.docFile.getName());
                    doc.setFolderId(this.currentFolder);
                    doc.setLanguage(this.currentDocument.getLanguage());
                    doc.setTags(this.currentDocument.getTags());
                    doc.setTemplateId(this.currentDocument.getTemplateId());
                    doc.setAttributes(this.currentDocument.getAttributes());
                    doc.setCustomId(this.currentDocument.getCustomId());
                    if (this.currentDocument.getImmutable() >= 0) {
                        doc.setImmutable(this.currentDocument.getImmutable());
                    }
                    if (this.currentDocument.getDate() != null) {
                        doc.setDate(this.currentDocument.getDate());
                    }
                    if (this.currentDocument.getCreation() != null) {
                        doc.setDate(this.currentDocument.getCreation());
                    }
                    doc.setPublished(this.currentDocument.getPublished());
                    doc.setStartPublishing(this.currentDocument.getStartPublishing());
                    doc.setStopPublishing(this.currentDocument.getStopPublishing());
                    WSDocument wsdoc = DMS.get().createDocument(doc, this.docFile);
                    DocumentHistory transaction = new DocumentHistory();
                    transaction.setEvent(DocumentEvent.STORED.toString());
                    transaction.setDocId(wsdoc.getId());
                    transaction.setFolderId(this.currentFolder);
                    transaction.setFilename(this.docFile.getName());
                    this.crawler.afterDocumentImported(this.importFolder, transaction);
                    cache.put(new ImportFolderCache.CacheEntry(this.currentPath, new Date(), doc.getId()));
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                    this.crawler.onError(this.importFolder, null, this.currentPath, e);
                    log.error("Error importing " + this.currentPath, e);
                }
            }
        }
        catch (Throwable t) {
            this.crawler.onError(this.importFolder, null, this.currentPath, t);
            log.error("Error importing document '{}'", (Object)this.currentDocument.getFileName());
        }
        finally {
            try {
                if (this.importFolder.getDelImport() == 1 && fileFound) {
                    FileUtils.forceDelete(this.docFile);
                    if (!this.docFile.exists()) {
                        log.warn("Deleted file: " + this.docFile.getName());
                    } else {
                        log.warn("Unable to delete file: " + this.docFile.getName());
                    }
                }
            }
            catch (Exception e) {
                log.warn("Unable to delete file: " + this.docFile.getName());
            }
            this.crawler.following();
        }
    }

    private void updateTemplate(WSDocument doc) {
        if (doc.getTemplateId() == null) {
            return;
        }
        boolean updated = false;
        WSTemplate template = this.templatesIds.get(doc.getTemplateId());
        for (String name : this.listAttributeNames(doc)) {
            if (template.listAttributeNames().contains(name)) continue;
            WSAttribute extAttribute = new WSAttribute();
            if (StringUtils.isNotEmpty(this.attribute(doc, name).getLabel())) {
                extAttribute.setLabel(this.attribute(doc, name).getLabel());
            } else {
                extAttribute.setLabel(name);
            }
            extAttribute.setMandatory(this.attribute(doc, name).getMandatory());
            extAttribute.setHidden(this.attribute(doc, name).getHidden());
            extAttribute.setHidden(this.attribute(doc, name).getHidden());
            extAttribute.setType(this.attribute(doc, name).getType());
            extAttribute.setName(name);
            template.addAttribute(extAttribute);
            updated = true;
        }
        if (updated) {
            try {
                DMS.get().storeTemplate(template);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            this.templates.put(template.getName(), template);
            this.templatesIds.put(template.getId(), template);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat dfWS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date;
            Date date22;
            if ("impex".equals(localName) || "attributes".equals(localName) || "attribute".equals(localName)) {
                return;
            }
            if ("document".equals(localName)) {
                this.endDocumentElement();
            }
            if ("immutable".equals(localName)) {
                this.currentDocument.setImmutable(Integer.parseInt(this.buffer.toString().trim()));
            }
            if ("version".equals(localName)) {
                this.currentDocument.setVersion(this.buffer.toString().trim());
            }
            if ("fileversion".equals(localName)) {
                this.currentDocument.setFileVersion(this.buffer.toString().trim());
            }
            if ("date".equals(localName)) {
                try {
                    date22 = df.parse(this.buffer.toString().trim());
                    this.currentDocument.setDate(dfWS.format(date22));
                }
                catch (ParseException date22) {
                    // empty catch block
                }
            }
            if ("creation".equals(localName) && StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                try {
                    date22 = df.parse(this.buffer.toString().trim());
                    this.currentDocument.setCreation(dfWS.format(date22));
                }
                catch (ParseException date3) {
                    // empty catch block
                }
            }
            if ("creator".equals(localName)) {
                this.currentDocument.setCreator(this.buffer.toString().trim());
            }
            if ("creatorid".equals(localName)) {
                this.currentDocument.setCreatorId(Long.parseLong(this.buffer.toString().trim()));
            }
            if ("publisher".equals(localName)) {
                this.currentDocument.setPublisher(this.buffer.toString().trim());
            }
            if ("status".equals(localName)) {
                this.currentDocument.setStatus(Integer.parseInt(this.buffer.toString().trim()));
            }
            if ("type".equals(localName)) {
                this.currentDocument.setType(this.buffer.toString().trim());
            }
            if ("language".equals(localName)) {
                this.currentDocument.setLanguage(this.buffer.toString().trim());
            }
            if ("filename".equals(localName)) {
                this.currentDocument.setFileName(this.buffer.toString().trim());
            }
            if ("filesize".equals(localName)) {
                this.currentDocument.setFileSize(Long.parseLong(this.buffer.toString().trim()));
            }
            if ("signed".equals(localName)) {
                this.currentDocument.setSigned(Integer.parseInt(this.buffer.toString().trim()));
            }
            if ("tags".equals(localName)) {
                ArrayList<String> tgs = new ArrayList<String>(TagUtil.extractTags("default", this.buffer.toString().trim()));
                this.currentDocument.setTags(tgs);
            }
            WSTemplate template = null;
            if ("template".equals(localName) && StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                if (this.templates.keySet().contains(this.buffer.toString().trim())) {
                    template = this.templates.get(this.buffer.toString().trim());
                } else {
                    template = new WSTemplate();
                    template.setName(this.buffer.toString().trim());
                    template.setDescription("");
                    DMS.get().storeTemplate(template);
                    this.templates.put(this.buffer.toString().trim(), template);
                    this.templatesIds.put(template.getId(), template);
                }
                this.currentDocument.setTemplateId(template.getId());
            }
            if ("pathextended".equals(localName)) {
                this.currentPathExtended = this.buffer.toString().trim();
            }
            if ("path".equals(localName)) {
                String path;
                this.currentPath = path = this.buffer.toString().trim();
                this.docFile = new File(this.importFolder.getPath(), path);
                if (StringUtils.isNotEmpty(this.currentPathExtended)) {
                    this.currentFolder = this.currentPathExtended.startsWith("/") ? DMS.get().createPath(5L, this.currentPathExtended).getId() : DMS.get().createPath(this.targetFolder, this.currentPathExtended).getId();
                } else if (path.contains("/")) {
                    path = path.substring(0, path.lastIndexOf(47));
                    this.currentFolder = DMS.get().createPath(this.targetFolder, path).getId();
                } else {
                    this.currentFolder = this.targetFolder;
                }
            }
            if ("published".equals(localName)) {
                try {
                    this.currentDocument.setPublished(Integer.parseInt(this.buffer.toString().trim()));
                }
                catch (NumberFormatException e) {
                    log.warn("element <published>: " + e.getMessage());
                }
            }
            if ("startpublishing".equals(localName)) {
                try {
                    date = df.parse(this.buffer.toString().trim());
                    this.currentDocument.setStartPublishing(dfWS.format(date));
                }
                catch (ParseException e) {
                    log.warn("element <startpublishing>: " + e.getMessage());
                }
            }
            if ("stoppublishing".equals(localName)) {
                try {
                    date = df.parse(this.buffer.toString().trim());
                    this.currentDocument.setStopPublishing(dfWS.format(date));
                }
                catch (ParseException e) {
                    log.warn("element <stoppublishing>: " + e.getMessage());
                }
            }
            if ("name".equals(localName)) {
                this.currentAttributeName = this.buffer.toString().trim();
            }
            if ("label".equals(localName)) {
                this.currentWSAttributeLabel = this.buffer.toString().trim();
            }
            if ("mandatory".equals(localName)) {
                this.currentWSAttributeMandatory = this.buffer.toString().trim();
            }
            if ("position".equals(localName)) {
                this.currentWSAttributePosition = this.buffer.toString().trim();
            }
            if ("hidden".equals(localName)) {
                this.currentWSAttributePosition = this.buffer.toString().trim();
            }
            if ("stringvalue".equals(localName)) {
                attribute = new WSAttribute();
                attribute.setLabel(this.currentWSAttributeLabel);
                attribute.setMandatory(Integer.parseInt(this.currentWSAttributeMandatory));
                attribute.setHidden(Integer.parseInt(this.currentWSAttributeHidden));
                attribute.setPosition(Integer.parseInt(this.currentWSAttributePosition));
                attribute.setType(0);
                attribute.setStringValue(this.buffer.toString().trim());
                attribute.setName(this.currentAttributeName);
                this.currentDocument.addAttribute(attribute);
            } else if ("intvalue".equals(localName)) {
                attribute = new WSAttribute();
                attribute.setLabel(this.currentWSAttributeLabel);
                attribute.setMandatory(Integer.parseInt(this.currentWSAttributeMandatory));
                attribute.setHidden(Integer.parseInt(this.currentWSAttributeHidden));
                attribute.setPosition(Integer.parseInt(this.currentWSAttributePosition));
                attribute.setType(1);
                attribute.setIntValue(Long.parseLong(this.buffer.toString().trim()));
                attribute.setName(this.currentAttributeName);
                this.currentDocument.addAttribute(attribute);
            } else if ("doublevalue".equals(localName)) {
                attribute = new WSAttribute();
                attribute.setLabel(this.currentWSAttributeLabel);
                attribute.setMandatory(Integer.parseInt(this.currentWSAttributeMandatory));
                attribute.setHidden(Integer.parseInt(this.currentWSAttributeHidden));
                attribute.setPosition(Integer.parseInt(this.currentWSAttributePosition));
                attribute.setType(2);
                attribute.setDoubleValue(Double.parseDouble(this.buffer.toString().trim()));
                attribute.setName(this.currentAttributeName);
                this.currentDocument.addAttribute(attribute);
            } else if ("datevalue".equals(localName)) {
                attribute = new WSAttribute();
                attribute.setLabel(this.currentWSAttributeLabel);
                attribute.setMandatory(Integer.parseInt(this.currentWSAttributeMandatory));
                attribute.setHidden(Integer.parseInt(this.currentWSAttributeHidden));
                attribute.setPosition(Integer.parseInt(this.currentWSAttributePosition));
                attribute.setType(3);
                Date date4 = df.parse(this.buffer.toString().trim());
                attribute.setDateValue(dfWS.format(date4));
                attribute.setName(this.currentAttributeName);
                this.currentDocument.addAttribute(attribute);
            }
            this.buffer = new StringBuilder();
        }
        catch (Throwable e) {
            log.error("Error retrieving values of document '" + this.currentDocument.getFileName() + "'");
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.append(ch[i + start]);
        }
    }

    public WSDocument getCurrentWSDocument() {
        return this.currentDocument;
    }

    private Collection<String> listAttributeNames(WSDocument doc) {
        ArrayList<String> names = new ArrayList<String>();
        for (WSAttribute att : doc.getAttributes()) {
            names.add(att.getName());
        }
        return names;
    }

    private WSAttribute attribute(WSDocument doc, String name) {
        for (WSAttribute att : doc.getAttributes()) {
            if (!att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }
}

