/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.lock.LockManager;
import com.logicaldoc.hotfolder.DMS;
import com.logicaldoc.hotfolder.LocalHelper;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderCacheManager;
import com.logicaldoc.importfolder.ImportFolderCrawler;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.model.WSFolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public class HotFolderCrawler
extends ImportFolderCrawler {
    public static final String NAME = "HotFolderCrawler";
    private long imported = 0L;
    private long updated = 0L;
    private long errors = 0L;
    private int count = 0;
    private long currentImportFolderCount = 0L;

    public HotFolderCrawler() {
        this.setName(NAME);
        this.log = LoggerFactory.getLogger(HotFolderCrawler.class);
        this.lockManager = new LockManager(){

            @Override
            public boolean get(String arg0, String arg1) {
                return true;
            }

            @Override
            protected boolean getInternal(String lockName, String transactionId) {
                return true;
            }

            @Override
            public void release(String lockName, String transactionId) {
            }
        };
    }

    private void checkConnection() throws Exception {
        DMS.get().testConnection();
        DMS.get().login(this.getConfig().getProperty("apikey").trim());
        if (StringUtils.isEmpty(DMS.get().getSid())) {
            throw new Exception("Unable to connect to DMS instance at " + this.getConfig().getProperty("url"));
        }
        this.log.info("License verified");
        this.log.info("Server connected");
    }

    public void crawlImportFolders() {
        this.errors = 0L;
        this.imported = 0L;
        this.updated = 0L;
        Collection<ImportFolder> folders = this.loadImportFolders();
        this.log.info("Found {} folders to import", (Object)folders.size());
        for (ImportFolder importFolder : folders) {
            if (this.interruptRequested) break;
            if (importFolder.getEnabled() < 1) continue;
            if (this.currentImportFolderCount >= importFolder.getBatch()) {
                this.log.info("Reached {} processed entries in import folder {}", (Object)importFolder.getBatch(), (Object)importFolder.getDisplayUrl());
                continue;
            }
            this.log.info("Process folder {}", (Object)importFolder.getDisplayUrl());
            try {
                try {
                    this.crawlImportFolder(importFolder);
                    System.gc();
                }
                catch (IOException e) {
                    this.log.error("Unable to process folder {}", (Object)importFolder.getDisplayUrl());
                    this.log.error(e.getMessage(), e);
                    if (this.currentImportFolderCount >= importFolder.getBatch()) continue;
                    this.setProgress(this.getProgress() + (importFolder.getBatch() - this.currentImportFolderCount));
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (this.currentImportFolderCount < importFolder.getBatch()) {
                    this.setProgress(this.getProgress() + (importFolder.getBatch() - this.currentImportFolderCount));
                }
                throw throwable;
            }
            if (this.currentImportFolderCount >= importFolder.getBatch()) continue;
            this.setProgress(this.getProgress() + (importFolder.getBatch() - this.currentImportFolderCount));
        }
    }

    private Collection<ImportFolder> loadImportFolders() {
        ArrayList<ImportFolder> folders = new ArrayList<ImportFolder>();
        ContextProperties config = Context.get().getProperties();
        int i = 0;
        while (i < 100) {
            if (StringUtils.isNotEmpty(config.getProperty("folder." + i + ".path"))) {
                ImportFolder importFolder = new ImportFolder();
                importFolder.setId(i);
                importFolder.setProvider("file");
                importFolder.setPath(config.getProperty("folder." + i + ".path"));
                importFolder.setDelImport("true".equals(config.getProperty("folder." + i + ".delete")) ? 1 : 0);
                importFolder.setDepth(config.getInt("folder." + i + ".depth"));
                importFolder.setEnabled("true".equals(config.getProperty("folder." + i + ".enabled")) ? 1 : 0);
                importFolder.setExcludes(config.getProperty("folder." + i + ".excludes"));
                importFolder.setIncludes(config.getProperty("folder." + i + ".includes"));
                importFolder.setLocale(LocaleUtil.toLocale(config.getProperty("folder." + i + ".locale")));
                importFolder.setTargetFolderId(Long.parseLong(config.getProperty("folder." + i + ".target").trim()));
                importFolder.setMaxSize(null);
                if (StringUtils.isNotEmpty(config.getProperty("folder." + i + ".template"))) {
                    importFolder.setTemplateId(Long.parseLong(config.getProperty("folder." + i + ".template")));
                }
                if (StringUtils.isNotEmpty(config.getProperty("folder." + i + ".tags"))) {
                    importFolder.setTags(config.getProperty("folder." + i + ".tags"));
                }
                importFolder.setBatch(config.getLong("folder." + i + ".batch"));
                folders.add(importFolder);
                this.log.debug("Found folder: {}", (Object)importFolder);
            }
            ++i;
        }
        return folders;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void crawlImportFolder(ImportFolder importFolder) throws IOException {
        helper = new LocalHelper(importFolder);
        targetFolder = null;
        try {
            targetFolder = DMS.get().getFolder(importFolder.getTargetFolderId());
        }
        catch (Exception e1) {
            this.log.error(e1.getMessage());
        }
        if (targetFolder == null) {
            this.log.error("Target Folder not found. Exit");
            ++this.errors;
            return;
        }
        try {
            importFromIndex = helper.importUsingIndex(this, targetFolder);
            if (importFromIndex) {
                this.setProgress(this.getProgress() + (long)helper.importDocumentsCount());
                return;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            return;
        }
        cache = Context.get(ImportFolderCacheManager.class).getCache(importFolder.getId());
        files = new ArrayList<Object>();
        try {
            helper.list(null, importFolder.getDepth(), files, importFolder.getBatch(), cache);
        }
        catch (Throwable t) {
            this.log.error(t.getMessage(), t);
        }
        this.log.info("Listed {} files", (Object)files.size());
        for (E file : files) {
            block28: {
                block29: {
                    if (this.interruptRequested) break;
                    if (this.currentImportFolderCount >= importFolder.getBatch()) {
                        this.log.info("Reached {} processed entries in import folder {}", (Object)importFolder.getBatch(), (Object)importFolder.getDisplayUrl());
                        break;
                    }
                    this.log.debug("Inspecting file {}", (Object)file.toString());
                    path = helper.getPath(file);
                    dir = "/";
                    lastSlash = path.lastIndexOf("/");
                    if (lastSlash > 0) {
                        dir = (String)dir + path.substring(0, lastSlash);
                    }
                    parentFolder = this.prepareWSFolder(importFolder, (String)dir);
                    if (cache.get(path) == null) ** GOTO lbl82
                    entry = cache.get(path);
                    lastImported = entry.getDate();
                    if (lastImported.compareTo(helper.getLastModified(file)) >= 0) break block28;
                    document = DMS.get().getDocument(entry.getDocId());
                    if (document == null) ** GOTO lbl66
                    if (document.getStatus() == DocumentStatus.UNLOCKED.ordinal()) break block29;
                    this.log.info("The document {} is locked or checked out", (Object)document.getFileName());
                    this.next();
                    continue;
                }
                try {
                    try {
                        block30: {
                            helper.checkinFile(file, entry.getDocId());
                            ++this.updated;
                            if (importFolder.getDelImport() == 1) {
                                deleted = helper.deleteFile(file);
                                if (deleted) {
                                    this.log.warn("Deleted file: {}", (Object)path);
                                } else {
                                    this.log.warn("Unable to delete file: {}", (Object)path);
                                }
                            }
                            break block30;
lbl66:
                            // 1 sources

                            document = helper.importFile(file, parentFolder.getId());
                            ++this.imported;
                            if (importFolder.getDelImport() == 1) {
                                deleted = helper.deleteFile(file);
                                if (deleted) {
                                    this.log.warn("Deleted file: {}", (Object)path);
                                } else {
                                    this.log.warn("Unable to delete file: {}", (Object)path);
                                }
                            }
                        }
                        cache.put(new ImportFolderCache.CacheEntry(path, new Date(), document.getId()));
                        {
                            catch (Throwable e) {
                                ++this.errors;
                                this.log.error("Error importing {}", (Object)path);
                                this.log.error(e.getMessage(), e);
                            }
                        }
                        break block28;
lbl82:
                        // 1 sources

                        try {
                            document = helper.importFile(file, parentFolder.getId());
                            cache.put(new ImportFolderCache.CacheEntry(path, new Date(), document.getId()));
                            ++this.imported;
                            if (importFolder.getDelImport() != 1) break block28;
                            deleted = helper.deleteFile(file);
                            if (deleted) {
                                this.log.warn("Deleted file: {}", (Object)path);
                                break block28;
                            }
                            this.log.warn("Unable to delete file: {}", (Object)path);
                        }
                        catch (Throwable e) {
                            ++this.errors;
                            this.log.error("Error importing {}", (Object)path);
                            this.log.error(e.getMessage(), e);
                        }
                    }
                    catch (Throwable t) {
                        this.log.error(t.getMessage(), t);
                        this.next();
                        continue;
                    }
                }
                catch (Throwable var16_25) {
                    this.next();
                    throw var16_25;
                }
            }
            this.next();
        }
    }

    @Override
    public boolean isIndeterminate() {
        return true;
    }

    private long count() {
        long count = 0L;
        Collection<ImportFolder> importFolders = this.loadImportFolders();
        for (ImportFolder importFolder : importFolders) {
            if (importFolder.getEnabled() < 1) continue;
            count += importFolder.getBatch();
        }
        return count;
    }

    @Override
    protected void runTask() {
        this.log.info("Start hot folder crawling of all folders");
        this.imported = 0L;
        this.updated = 0L;
        this.errors = 0L;
        this.count = 0;
        try {
            try {
                this.checkConnection();
            }
            catch (Exception e1) {
                this.log.error(e1.getMessage(), e1);
                ++this.errors;
                this.log.info("Hot Folders crawl finished");
                this.log.info("Imported documents: {}", (Object)this.imported);
                this.log.info("Updated documents: {}", (Object)this.updated);
                this.log.info("Errors: {}", (Object)this.errors);
                DMS.get().logout();
                return;
            }
            this.log.info("Started session " + DMS.get().getSid());
            this.size = this.count();
            this.log.info("Found a total of " + this.size + " files");
            this.crawlImportFolders();
        }
        finally {
            this.log.info("Hot Folders crawl finished");
            this.log.info("Imported documents: {}", (Object)this.imported);
            this.log.info("Updated documents: {}", (Object)this.updated);
            this.log.info("Errors: {}", (Object)this.errors);
            DMS.get().logout();
        }
    }

    @Override
    protected String prepareReport(Locale locale) {
        StringBuffer sb = new StringBuffer();
        sb.append(I18N.message("importeddocs", locale) + ": ");
        sb.append(this.imported);
        sb.append("\n");
        sb.append(I18N.message("updateddocs", locale) + ": ");
        sb.append(this.updated);
        sb.append("\n");
        sb.append(I18N.message("errors", locale) + ": ");
        sb.append(this.errors);
        return sb.toString();
    }

    public int getCount() {
        return this.count;
    }

    public long getImported() {
        return this.imported;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getErrors() {
        return this.errors;
    }

    public void setImported(long imported) {
        this.imported = imported;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public void setErrors(long errors) {
        this.errors = errors;
    }

    private WSFolder prepareWSFolder(ImportFolder importFolder, String path) throws Exception {
        WSFolder folder = DMS.get().createPath(importFolder.getTargetFolderId(), path);
        return folder;
    }

    @Override
    public boolean isConcurrent() {
        return super.isConcurrent();
    }

    public void onError(ImportFolder importFolder, Document document, String originalPath, Throwable error) {
        ++this.errors;
        this.log.error("Error importing {}", (Object)originalPath);
        this.log.error(error.getMessage(), error);
    }

    public void afterDocumentImported(ImportFolder importFolder, DocumentHistory transaction) {
        boolean newFile = DocumentEvent.STORED.toString().equals(transaction.getEvent());
        if (newFile) {
            ++this.imported;
        } else {
            ++this.updated;
        }
    }

    public void following() {
        super.next();
    }
}

