/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder;

import com.logicaldoc.hotfolder.DMS;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.webservice.soap.client.SoapAuthClient;
import com.logicaldoc.webservice.soap.client.SoapSystemClient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class HotFolder {
    private static final Logger log = LoggerFactory.getLogger(HotFolder.class);
    protected ApplicationContext context;
    protected SoapSystemClient systemClient;
    protected SoapAuthClient authClient;
    private static HotFolder instance;
    private static File pidFile;

    public static HotFolder get() {
        if (instance == null) {
            instance = new HotFolder();
        }
        return instance;
    }

    public static void main(String[] args) {
        HotFolder.initializeLogging();
        try {
            if (args == null || args.length == 0) {
                HotFolder.get().start();
            }
            if ("start".equals(args[0])) {
                HotFolder.get().start();
            } else if ("stop".equals(args[0])) {
                HotFolder.get().stop();
            } else if ("restart".equals(args[0])) {
                HotFolder.get().stop();
                while (pidFile.exists()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Throwable throwable) {}
                }
                HotFolder.get().start();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            log.error(e.getMessage(), e);
        }
    }

    private static String getLogConfigFilePath() throws UnsupportedEncodingException {
        URL configFile = null;
        try {
            configFile = HotFolder.class.getClassLoader().getResource("/log.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configFile == null) {
            configFile = HotFolder.class.getClassLoader().getResource("log.xml");
        }
        String log4jPath = URLDecoder.decode(configFile.getPath(), "UTF-8");
        return log4jPath;
    }

    private static void initializeLogging() {
        String log4jPath = null;
        try {
            log4jPath = HotFolder.getLogConfigFilePath();
            System.out.println(String.format("Taking log configuration from %s", log4jPath));
            LoggerContext lContext = Configurator.initialize(null, log4jPath);
            if (lContext == null) {
                throw new IOException("Null logger context");
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Cannot initialize the log: %s", e.getMessage()));
        }
    }

    public void stop() throws Exception {
        pidFile.delete();
        if (pidFile.exists()) {
            FileUtils.forceDelete(pidFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        Thread[] threadArray;
        log.info("HotFolder terminated");
        System.out.println("Shutting down");
        try {
            DMS.get().logout();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ((AbstractApplicationContext)this.context).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray2 = threadArray = threadSet.toArray(new Thread[threadSet.size()]);
        int n = threadArray2.length;
        for (int i = 0; i < n; ++i) {
            Thread t;
            Thread thread = t = threadArray2[i];
            synchronized (thread) {
                if (t.getName().startsWith("Scheduler_") || t.getName().startsWith("Abandoned connection cleanup") && !Thread.currentThread().equals(t)) {
                    try {
                        t.stop();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                continue;
            }
        }
        System.out.println("HotFolder terminated");
        log.info("HotFolder terminated");
        System.exit(0);
    }

    public void start() throws Exception {
        this.writePid();
        Thread whatchdog = new Thread(){

            @Override
            public void run() {
                while (pidFile.exists()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    HotFolder.this.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        whatchdog.start();
        new ContextProperties();
        this.context = new ClassPathXmlApplicationContext(new String[]{"/context.xml"});
        log.info("HotFolder started");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(60000L);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writePid() {
        OutputStreamWriter fw = null;
        String pid = null;
        try {
            pid = ManagementFactory.getRuntimeMXBean().getName();
            pid = pid.substring(0, pid.indexOf("@"));
            fw = new FileWriter(pidFile, false);
            fw.write(pid);
            fw.flush();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException iOException) {}
        }
        return pid;
    }

    static {
        pidFile = new File("pid");
    }
}

