/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class Dir {
    private String path;
    private Long targetFolderId;
    private Integer maxSize = null;
    private String includes = "*.pdf,*.doc,*.xls";
    private String excludes = "*~,#*#,.#*,%*%,._*,.DS_Store";
    private String tags = "";
    private String language = "en";
    private Long templateId;
    private int depth = 20;
    private int delImport = 0;
    private static Dir instance;

    public static Dir get() {
        if (instance == null) {
            instance = new Dir();
        }
        return instance;
    }

    private Dir() {
        ContextProperties config = Context.get().getBean(ContextProperties.class);
        this.setPath(config.getProperty("folder.0.path"));
        this.setDelImport("true".equals(config.getProperty("folder.0.delete")) ? 1 : 0);
        this.setDepth(config.getInt("folder.0.depth"));
        this.setExcludes(config.getProperty("folder.0.excludes"));
        this.setIncludes(config.getProperty("folder.0.includes"));
        this.setLanguage(config.getProperty("folder.0.locale"));
        this.setTargetFolderId(Long.parseLong(config.getProperty("folder.0.target").trim()));
        this.setMaxSize(null);
        if (StringUtils.isNotEmpty(config.getProperty("folder.0.template"))) {
            this.setTemplateId(Long.parseLong(config.getProperty("folder.0.template")));
        }
        if (StringUtils.isNotEmpty(config.getProperty("folder.0.tags"))) {
            this.setTags(config.getProperty("folder.0.tags"));
        }
    }

    public String getPath() {
        return this.path;
    }

    public File getRoot() {
        return new File(this.path);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getTargetFolderId() {
        return this.targetFolderId;
    }

    public void setTargetFolderId(Long targetFolderId) {
        this.targetFolderId = targetFolderId;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDelImport() {
        return this.delImport;
    }

    public void setDelImport(int delImport) {
        this.delImport = delImport;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getRelativePath(File file) {
        String absolutePath = file.getAbsolutePath();
        File localFolder = new File(this.getPath());
        String localPath = localFolder.getAbsolutePath();
        String relativePath = absolutePath.substring(localPath.length());
        if ((relativePath = relativePath.replace('\\', '/')).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    public File getFile(String relativePath) {
        return new File(this.getPath() + "/" + relativePath);
    }
}

