/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder;

import com.logicaldoc.enterprise.webservice.soap.client.SoapEnterpriseDocumentClient;
import com.logicaldoc.hotfolder.Dir;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.http.HttpUtil;
import com.logicaldoc.util.http.StreamHttpClientResponseHandler;
import com.logicaldoc.util.time.TimeDiff;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.model.WSSystemInfo;
import com.logicaldoc.webservice.model.WSTemplate;
import com.logicaldoc.webservice.soap.client.SoapAuthClient;
import com.logicaldoc.webservice.soap.client.SoapDocumentClient;
import com.logicaldoc.webservice.soap.client.SoapDocumentMetadataClient;
import com.logicaldoc.webservice.soap.client.SoapFolderClient;
import com.logicaldoc.webservice.soap.client.SoapSystemClient;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMS {
    private static final String FEATURE_91 = "Feature_91";
    private static final Logger log = LoggerFactory.getLogger(DMS.class);
    private static DMS instance;
    private SoapAuthClient auth;
    private SoapFolderClient fld;
    private SoapDocumentClient documentClient;
    private SoapDocumentMetadataClient metadataClient;
    private SoapEnterpriseDocumentClient enterpriseDocumentClient;
    private String sid;
    private ContextProperties config;
    private static Date lastLicenseCheck;
    private long[] timeDiff = new long[]{0L, 0L, 0L, 0L, 0L};

    public static DMS get() {
        if (instance == null) {
            instance = new DMS(null);
        }
        return instance;
    }

    public DMS(ContextProperties config) {
        try {
            if (config != null) {
                this.config = config;
            } else {
                try {
                    this.config = new ContextProperties();
                }
                catch (Throwable t) {
                    this.config = new ContextProperties("conf/context.properties");
                }
            }
            log.info("Instantiating DMS gateway on {}", (Object)this.config.getProperty("url"));
            this.auth = new SoapAuthClient(this.config.getProperty("url") + "/services/Auth");
            this.fld = new SoapFolderClient(this.config.getProperty("url") + "/services/Folder");
            this.documentClient = new SoapDocumentClient(this.config.getProperty("url") + "/services/Document");
            this.metadataClient = new SoapDocumentMetadataClient(this.config.getProperty("url") + "/services/DocumentMetadata");
            this.enterpriseDocumentClient = new SoapEnterpriseDocumentClient(this.config.getProperty("url") + "/services/EnterpriseDocument");
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }

    public synchronized String login(String apiKey) {
        if (this.sid == null || !this.auth.valid(this.sid)) {
            try {
                this.testLicense();
                this.sid = this.auth.loginApiKey(apiKey);
                if (StringUtils.isEmpty(this.sid)) {
                    throw new Exception("Unable to connect to LogicalDOC instance at " + this.config.getProperty("url"));
                }
                log.info("Server connected");
                log.info("Started session {}", (Object)this.sid);
            }
            catch (Exception e1) {
                log.error(e1.getMessage(), e1);
                return null;
            }
        } else {
            return this.sid;
        }
        try {
            Date localDate = new Date();
            WSSystemInfo info = DMS.get().getInfo();
            Date afterResponse = new Date();
            boolean featureEnabled = false;
            for (String feature : info.getFeatures()) {
                if (!FEATURE_91.equals(feature)) continue;
                featureEnabled = true;
                break;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date serverDate = df.parse(info.getDate());
            long[] requestDiff = TimeDiff.getTimeDifference(localDate, afterResponse);
            Calendar cal = Calendar.getInstance();
            cal.setTime(localDate);
            cal.add(11, 24 * (int)requestDiff[0] / 2);
            cal.add(11, (int)requestDiff[1] / 2);
            cal.add(12, (int)requestDiff[2] / 2);
            cal.add(13, (int)requestDiff[3] / 2);
            cal.add(14, 0);
            localDate = cal.getTime();
            this.timeDiff = TimeDiff.getTimeDifference(localDate, serverDate);
            log.warn("Time difference with the server is " + this.timeDiff[0] + " day(s), " + this.timeDiff[1] + " hour(s), " + this.timeDiff[2] + " minute(s), " + this.timeDiff[3] + " second(s) \n");
            if (!featureEnabled) {
                throw new Exception("Feature not enabled in the license");
            }
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), e1);
            this.sid = null;
        }
        return this.sid;
    }

    public void testLicense() throws IOException {
        if (lastLicenseCheck == null) {
            this.testConnection();
            lastLicenseCheck = new Date();
        } else {
            Date now = new Date();
            long diff = now.getTime() - lastLicenseCheck.getTime();
            long diffMinutes = diff / 60000L;
            if (diffMinutes > 30L) {
                this.testConnection();
                lastLicenseCheck = now;
            }
        }
    }

    public synchronized void logout() {
        if (this.sid != null) {
            this.auth.logout(this.sid);
        }
        log.info("Closed session {}", (Object)this.sid);
        System.out.println("Closed session " + this.sid);
        this.sid = null;
    }

    public void download(long docId, OutputStream dest) throws IOException {
        try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(60);){
            httpClient.execute((ClassicHttpRequest)new HttpGet(this.config.getProperty("url") + "/download?sid=" + this.sid + "&docId=" + docId), (HttpClientResponseHandler)new StreamHttpClientResponseHandler(dest));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(long docId, File dest) throws Exception {
        WSDocument doc = this.documentClient.getDocument(this.sid, docId);
        if (doc == null) {
            return;
        }
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        FileOutputStream os = new FileOutputStream(dest);
        try {
            this.download(docId, os);
        }
        finally {
            os.flush();
            ((OutputStream)os).close();
        }
    }

    public void download(WSDocument doc, File dest) throws Exception {
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(dest);){
            this.download(doc.getId(), os);
            os.flush();
        }
    }

    public void downloadTree(WSFolder folder, File dest) {
        if (folder == null) {
            return;
        }
        log.info("Download tree {}", (Object)folder.getId());
        List<WSDocument> docs = null;
        try {
            docs = this.documentClient.listDocuments(this.sid, folder.getId(), null);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return;
        }
        dest.mkdirs();
        dest.mkdir();
        HashSet<String> fileNames = new HashSet<String>();
        if (docs != null) {
            for (WSDocument wsDoc : docs) {
                String filename = wsDoc.getFileName();
                fileNames.add(filename);
                File f = new File(dest, filename);
                boolean exists = f.exists();
                if (exists && !this.before(new Date(f.lastModified()), AbstractService.convertStringToDate(wsDoc.getDate()))) continue;
                try {
                    log.info("Downloading file {}", (Object)f.getName());
                    this.download(wsDoc, f);
                    log.debug("Wrote file {}", (Object)f.getAbsolutePath());
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        List<WSFolder> folders = null;
        try {
            folders = this.fld.listChildren(this.sid, folder.getId());
            if (folders != null) {
                log.debug("Found {} inside {}", (Object)folders.size(), (Object)folder.getName());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return;
        }
        if (folders != null) {
            for (WSFolder f : folders) {
                this.downloadTree(f, new File(dest, f.getName()));
            }
        }
    }

    public List<WSDocument> list(long folderId) throws Exception {
        return this.documentClient.listDocuments(this.sid, folderId, null);
    }

    public List<WSFolder> listChildren(long parentId) throws Exception {
        return this.fld.listChildren(this.sid, parentId);
    }

    public WSFolder getFolder(long folderId) throws Exception {
        return this.fld.getFolder(this.sid, folderId);
    }

    public WSFolder getFolder(String path) throws Exception {
        return this.fld.findByPath(this.sid, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static WSFolder getFolder(String url, String username, String password, String path) throws Exception {
        WSFolder wSFolder;
        SoapAuthClient a;
        String sid;
        block12: {
            sid = null;
            a = null;
            a = new SoapAuthClient(url + "/services/Auth");
            SoapFolderClient f = new SoapFolderClient(url + "/services/Folder");
            sid = a.login(username, password);
            wSFolder = f.findByPath(sid, path);
            if (sid == null || a == null) break block12;
            try {
                a.logout(sid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return wSFolder;
        catch (Throwable throwable) {
            if (sid != null && a != null) {
                try {
                    a.logout(sid);
                }
                catch (Throwable throwable2) {}
            }
            catch (Throwable throwable3) {
                if (sid != null && a != null) {
                    try {
                        a.logout(sid);
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                }
                throw throwable3;
            }
        }
        return null;
    }

    public WSFolder getTargetFolder() throws Exception {
        return this.fld.getFolder(this.sid, Dir.get().getTargetFolderId());
    }

    public WSSystemInfo getInfo() {
        try {
            return DMS.getInfo(this.config.getProperty("url"));
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            return null;
        }
    }

    public static synchronized WSSystemInfo getInfo(String url) throws Exception {
        SoapSystemClient system = new SoapSystemClient(url + "/services/System");
        return system.getInfo();
    }

    public String getRemotePath(File file) throws Exception {
        String relativePath = Dir.get().getRelativePath(file);
        if (file.isFile()) {
            relativePath = Dir.get().getRelativePath(file.getParentFile());
        }
        List<WSFolder> path = this.fld.getPath(this.sid, Dir.get().getTargetFolderId());
        StringBuffer fullPath = new StringBuffer();
        for (WSFolder wsFolder : path) {
            fullPath.append(wsFolder.getName());
            if ("/".equals(wsFolder.getName())) continue;
            fullPath.append("/");
        }
        fullPath.append(relativePath);
        return fullPath.toString();
    }

    private WSDocument getDocument(File file) throws Exception {
        WSFolder remoteFolder = this.fld.findByPath(this.sid, this.getRemotePath(file.getParentFile()));
        if (remoteFolder == null) {
            return null;
        }
        List<WSDocument> docs = this.documentClient.listDocuments(this.sid, remoteFolder.getId(), file.getName());
        return docs.get(0);
    }

    public WSDocument getDocument(long docId) throws Exception {
        return this.documentClient.getDocument(this.sid, docId);
    }

    public void delete(File file) throws Exception {
        WSDocument doc = this.getDocument(file);
        if (doc != null) {
            this.documentClient.delete(this.sid, doc.getId());
            return;
        }
        WSFolder remoteFolder = this.fld.findByPath(this.sid, this.getRemotePath(file));
        if (remoteFolder != null) {
            this.fld.delete(this.sid, remoteFolder.getId());
        }
    }

    public void uploadNewRevision(long docId, File file, String comment) throws Exception {
        boolean chunking;
        this.documentClient.checkout(this.sid, docId);
        boolean bl = chunking = file.length() > this.getChunkSize();
        if (chunking) {
            log.info("Upload file {} in chunks of {}", (Object)file.getPath(), (Object)StringUtil.printFileSize(this.getChunkSize()));
            this.enterpriseDocumentClient.uploadChunks(this.sid, file, this.getChunkSize());
            log.info("All chunks of file {} were uploaded", (Object)file.getPath());
            this.enterpriseDocumentClient.checkin(this.sid, docId, comment, file.getName(), true, null);
        } else {
            this.documentClient.checkin(this.sid, docId, comment, file.getName(), true, new DataHandler((DataSource)new FileDataSource(file)));
        }
    }

    public WSDocument createDocument(WSDocument doc, File file) throws Exception {
        boolean chunking;
        boolean bl = chunking = file.length() > this.getChunkSize();
        if (chunking) {
            log.info("Upload file {} in chunks of {}", (Object)file.getPath(), (Object)StringUtil.printFileSize(this.getChunkSize()));
            this.enterpriseDocumentClient.uploadChunks(this.sid, file, this.getChunkSize());
            log.info("All chunks of file {} were uploaded", (Object)file.getPath());
            return this.enterpriseDocumentClient.create(this.sid, doc);
        }
        return this.documentClient.create(this.sid, doc, file);
    }

    private long getChunkSize() {
        return (long)this.config.getInt("packet.size", 20) * 1024L * 1024L;
    }

    public void storeTemplate(WSTemplate template) throws Exception {
        this.metadataClient.storeTemplate(this.sid, template);
    }

    public List<WSTemplate> listTemplates() throws Exception {
        return this.metadataClient.listTemplates(this.sid);
    }

    public WSFolder createRemotePath(File file) throws Exception {
        String relativeFolderPath = Dir.get().getRelativePath(file);
        if (file.isFile()) {
            relativeFolderPath = Dir.get().getRelativePath(file.getParentFile());
        }
        long targetFolderId = Dir.get().getTargetFolderId();
        if (StringUtils.isNotEmpty(relativeFolderPath)) {
            targetFolderId = this.fld.createPath(this.sid, Dir.get().getTargetFolderId(), relativeFolderPath).getId();
        }
        return this.getFolder(targetFolderId);
    }

    public WSFolder createPath(long parentId, String path) throws Exception {
        return this.fld.createPath(this.sid, parentId, path);
    }

    public boolean before(Date localDate, Date remoteDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(localDate);
        cal.add(14, 0);
        Date locDate = cal.getTime();
        return locDate.before(remoteDate);
    }

    public void testConnection() throws IOException {
        WSSystemInfo info = this.getInfo();
        if (info == null) {
            log.error("Server unreacheable or webservices not available");
            throw new IOException("Server unreacheable or webservices not available");
        }
        boolean featureEnabled = false;
        for (String feature : info.getFeatures()) {
            if (!feature.equals(FEATURE_91)) continue;
            featureEnabled = true;
            break;
        }
        if (!featureEnabled) {
            log.error("Feature not enabled on the server");
            throw new IOException("Feature not enabled on the server");
        }
        log.info("The feature is enabled on the server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testCredentials(String url, String username, String password) throws IOException {
        SoapAuthClient auth = null;
        String sid = null;
        try {
            auth = new SoapAuthClient(url + "/services/Auth");
            try {
                sid = auth.login(username, password);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (StringUtils.isEmpty(sid)) {
                throw new IOException("Invalid credentials");
            }
            log.info("Server connected");
        }
        catch (Throwable throwable) {
            try {
                if (auth != null && sid != null) {
                    auth.logout(sid);
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (auth != null && sid != null) {
                auth.logout(sid);
            }
        }
        catch (Throwable throwable) {}
    }

    public static boolean validateLicense(String url) {
        log.info("Try to contact LogicalDOC: {}", (Object)url);
        try {
            WSSystemInfo info = DMS.getInfo(url);
            if (info == null || info.getFeatures() == null) {
                throw new Exception("Unable to connect");
            }
            for (String feature : info.getFeatures()) {
                if (!FEATURE_91.equals(feature)) continue;
                return true;
            }
            log.info("Feature not enabled in the license");
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("{}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            log.error(e.getMessage(), e);
        }
        return false;
    }

    public String getSid() {
        return this.sid;
    }

    static {
        lastLicenseCheck = null;
    }
}

