/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.hotfolder;

import com.logicaldoc.hotfolder.HotFolderCrawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSFolder;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrawlerHelper {
    private static final Logger log = LoggerFactory.getLogger(CrawlerHelper.class);
    protected ImportFolder importFolder;

    public CrawlerHelper(ImportFolder importFolder, String sid) {
        this.importFolder = importFolder;
    }

    public abstract void list(Object var1, int var2, List<Object> var3, long var4, ImportFolderCache var6) throws Exception;

    public abstract WSDocument importFile(Object var1, long var2) throws Exception;

    public abstract void checkinFile(Object var1, long var2) throws Exception;

    public abstract String getPath(Object var1) throws Exception;

    public abstract Date getLastModified(Object var1) throws Exception;

    public abstract Date getCreationDate(Object var1);

    public boolean toBeImported(Object file, ImportFolderCache cache) throws Exception {
        String path = this.getPath(file);
        Date lastModified = this.getLastModified(file);
        ImportFolderCache.CacheEntry entry = cache.get(path);
        if (entry == null) {
            return true;
        }
        return entry.getDate().before(lastModified);
    }

    public abstract boolean importUsingIndex(HotFolderCrawler var1, WSFolder var2) throws Exception;

    public abstract int importDocumentsCount() throws Exception;

    public abstract boolean deleteFile(Object var1);
}

