/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.util;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.imaging.ImageUtil;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserType;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.talanlabs.avatargenerator.Avatar;
import com.talanlabs.avatargenerator.IdenticonAvatar;
import com.timgroup.jgravatar.Gravatar;
import com.timgroup.jgravatar.GravatarDefaultImage;
import com.timgroup.jgravatar.GravatarRating;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtil {
    private static final String AVATAR = "avatar";
    private static final String ERROR_GENERATING_DEFAULT_THE_AVATAR_FOR_USER = "Error generating default the avatar for user {}";
    private static final String TRANSPARENT_IMAGE = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";
    private static final Logger log = LoggerFactory.getLogger(UserUtil.class);

    private UserUtil() {
    }

    public static File getUserHome(long id) {
        File root = UserUtil.getUsersDir();
        File userDir = new File(root, Long.toString(id));
        if (!userDir.exists()) {
            try {
                FileUtils.forceMkdir(userDir);
            }
            catch (IOException e) {
                return null;
            }
        }
        return userDir;
    }

    public static File getUserResource(long id, String path) {
        File root = UserUtil.getUserHome(id);
        File resource = new File((root != null ? root.getPath() : "") + "/" + path);
        if (!resource.exists() && !path.contains(".")) {
            try {
                FileUtils.forceMkdir(resource);
            }
            catch (IOException e) {
                return null;
            }
        }
        return resource;
    }

    public static File getUsersDir() {
        File userpath = new File("");
        try {
            ContextProperties conf = Context.get().getProperties();
            userpath = new File(conf.getProperty("conf.userdir"));
            FileUtils.forceMkdir(userpath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userpath;
    }

    public static void saveAvatar(User user, File avatarImageFile, String imageType) {
        UserDAO userDao = Context.get(UserDAO.class);
        TenantDAO tenantDao = Context.get(TenantDAO.class);
        File tmpAvatarImage = null;
        try {
            try {
                userDao.initialize(user);
                if ("svg".equalsIgnoreCase(imageType)) {
                    user.setAvatar("data:image/svg+xml;base64," + ImageUtil.encode(avatarImageFile));
                } else {
                    String tenantName = tenantDao.getTenantName(user.getTenantId());
                    int size = Context.get().getProperties().getInt(tenantName + ".gui.avatar.size", 128);
                    tmpAvatarImage = FileUtil.createTempFile(AVATAR, ".png");
                    BufferedImage avatar = ImageIO.read(avatarImageFile);
                    avatar = ImageUtil.cropCenterSquare(avatar, size);
                    ImageIO.write((RenderedImage)avatar, "png", tmpAvatarImage);
                    user.setAvatar("data:image/png;base64," + ImageUtil.encode(tmpAvatarImage));
                }
                userDao.store(user);
            }
            catch (Exception t) {
                log.warn(ERROR_GENERATING_DEFAULT_THE_AVATAR_FOR_USER, (Object)user, (Object)t);
                FileUtil.delete(tmpAvatarImage);
            }
        }
        finally {
            FileUtil.delete(tmpAvatarImage);
        }
    }

    public static void generateDefaultAvatar(User user) {
        block8: {
            UserDAO userDao = Context.get(UserDAO.class);
            File tmpAvatarImage = null;
            try {
                try {
                    userDao.initialize(user);
                    tmpAvatarImage = FileUtil.createTempFile(AVATAR, ".png");
                    TenantDAO tenantDao = Context.get(TenantDAO.class);
                    String tenantName = tenantDao.getTenantName(user.getTenantId());
                    int size = Context.get().getProperties().getInt(tenantName + ".gui.avatar.size", 128);
                    BufferedImage avatar = UserUtil.generateDefaultAvatarImage(user, size);
                    ImageIO.write((RenderedImage)avatar, "png", tmpAvatarImage);
                    user.setAvatar("data:image/png;base64," + ImageUtil.encode(tmpAvatarImage));
                    if (user.getType() != UserType.SYSTEM) {
                        userDao.store(user);
                    } else {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put(AVATAR, user.getAvatar());
                        params.put("username", user.getUsername());
                        userDao.jdbcUpdate("update ld_user set ld_avatar = :avatar where ld_username = :username", params);
                    }
                }
                catch (Exception t) {
                    if (log.isDebugEnabled()) {
                        log.debug(ERROR_GENERATING_DEFAULT_THE_AVATAR_FOR_USER, (Object)user, (Object)t);
                    }
                    FileUtil.delete(tmpAvatarImage);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(tmpAvatarImage);
                throw throwable;
            }
            FileUtil.delete(tmpAvatarImage);
        }
    }

    private static BufferedImage generateDefaultAvatarImage(User user, int size) {
        BufferedImage avatarImage = UserUtil.getImageFromGravatar(user, size);
        if (avatarImage == null) {
            try {
                Avatar avatar = IdenticonAvatar.newAvatarBuilder().size(size, size).build();
                avatarImage = avatar.create(user.getId() > 0L ? user.getId() : -user.getId());
            }
            catch (Exception t) {
                log.warn("Cannot generate avatar for user {}", (Object)user, (Object)t);
            }
        }
        avatarImage = UserUtil.getImageCentralSquare(size, avatarImage);
        return avatarImage;
    }

    protected static BufferedImage getImageFromGravatar(User user, int size) {
        byte[] bytes;
        if (!Context.get().getProperties().getBoolean("gravatar.enabled", false)) {
            return null;
        }
        BufferedImage avatarImage = null;
        Gravatar gravatar = new Gravatar();
        gravatar.setRating(GravatarRating.GENERAL_AUDIENCES);
        gravatar.setDefaultImage(GravatarDefaultImage.GRAVATAR_ICON);
        gravatar.setSize(size);
        try {
            bytes = gravatar.download(user.getEmail());
            if (bytes != null && bytes.length > 0) {
                avatarImage = ImageIO.read(new ByteArrayInputStream(bytes));
            }
        }
        catch (Exception t) {
            log.warn("Cannot download gravatar for email {}", (Object)user.getEmail(), (Object)t);
        }
        if (avatarImage == null && StringUtils.isNotEmpty((CharSequence)user.getEmail2())) {
            try {
                bytes = gravatar.download(user.getEmail2());
                if (bytes != null && bytes.length > 0) {
                    avatarImage = ImageIO.read(new ByteArrayInputStream(bytes));
                }
            }
            catch (Exception t) {
                log.warn("Cannot download gravatar for email {}", (Object)user.getEmail2(), (Object)t);
            }
        }
        return avatarImage;
    }

    private static BufferedImage getImageCentralSquare(int size, BufferedImage avatarImage) {
        if (avatarImage != null && (avatarImage.getWidth() > size || avatarImage.getHeight() > size)) {
            avatarImage = ImageUtil.cropCenterSquare(avatarImage, size);
        }
        return avatarImage;
    }

    public static String getAvatarImage(String userIdOrName) throws PersistenceException {
        String content = TRANSPARENT_IMAGE;
        UserDAO userDao = Context.get(UserDAO.class);
        User user = null;
        if (userIdOrName != null) {
            try {
                user = (User)userDao.findById(Long.parseLong(userIdOrName));
            }
            catch (Exception t) {
                user = userDao.findByUsername(userIdOrName);
            }
        }
        if (user != null) {
            if (StringUtils.isEmpty((CharSequence)user.getAvatar())) {
                UserUtil.generateDefaultAvatar(user);
            }
            content = user.getAvatar();
        }
        return content;
    }
}

