/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFImageExtractor
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PDFImageExtractor.class);
    private PDDocument document = null;

    public PDFImageExtractor(File pdfFile) {
        try {
            this.document = PDDocument.load((File)pdfFile);
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.document != null) {
            this.document.close();
            this.document = null;
        }
    }

    public int getNumberOfPages() {
        try {
            return this.document.getPages().getCount();
        }
        catch (Exception t) {
            log.warn(t.getMessage());
            return 1;
        }
    }

    public BufferedImage getPageAsImage(int pageIndex) throws IOException {
        PDFRenderer pdfRenderer = new PDFRenderer(this.document);
        return pdfRenderer.renderImageWithDPI(pageIndex, 300.0f, ImageType.RGB);
    }

    public BufferedImage extractImage(int pageIndex, COSName imageKey) throws IOException {
        return this.extractImage(this.document.getPages().get(pageIndex), imageKey);
    }

    private BufferedImage extractImage(PDPage page, COSName imageKey) throws IOException {
        PDResources resources = page.getResources();
        Map<COSName, PDImageXObject> images = this.getImagesFromResources(resources);
        PDImageXObject image = images.get(imageKey);
        BufferedImage image2 = null;
        try {
            BufferedImage bi = image.getImage();
            if (bi == null) {
                throw new IOException("Error image is null");
            }
            image2 = this.correctRotation(bi, page.getRotation());
        }
        catch (Exception e) {
            log.warn("Unable to read: {} bits: {} Suffix: {}", image.getClass(), image.getBitsPerComponent(), image.getSuffix());
        }
        return image2;
    }

    private BufferedImage correctRotation(BufferedImage bi, int pageRotation) {
        if (pageRotation == 0) {
            return bi;
        }
        BufferedImage rotatedImage = bi;
        int i = 0;
        while (i < pageRotation) {
            rotatedImage = this.rotate90DX(rotatedImage);
            i += 90;
        }
        return rotatedImage;
    }

    private BufferedImage rotate90DX(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        BufferedImage biFlip = new BufferedImage(height, width, bi.getType());
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                biFlip.setRGB(height - 1 - j, i, bi.getRGB(i, j));
                ++j;
            }
            ++i;
        }
        return biFlip;
    }

    public BufferedImage rotate90SX(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        BufferedImage biFlip = new BufferedImage(height, width, bi.getType());
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                biFlip.setRGB(j, width - 1 - i, bi.getRGB(i, j));
                ++j;
            }
            ++i;
        }
        return biFlip;
    }

    public Set<COSName> getImageKeys(int pageIndex) throws IOException {
        PDResources resources = this.document.getPages().get(pageIndex).getResources();
        return this.getImagesFromResources(resources).keySet();
    }

    private Map<COSName, PDImageXObject> getImagesFromResources(PDResources resources) throws IOException {
        HashMap<COSName, PDImageXObject> images = new HashMap<COSName, PDImageXObject>();
        for (COSName xObjectName : resources.getXObjectNames()) {
            PDXObject xObject = resources.getXObject(xObjectName);
            if (xObject instanceof PDFormXObject) {
                PDFormXObject pdFormXObject = (PDFormXObject)xObject;
                images.putAll(this.getImagesFromResources(pdFormXObject.getResources()));
                continue;
            }
            if (!(xObject instanceof PDImageXObject)) continue;
            PDImageXObject pdImageXObject = (PDImageXObject)xObject;
            images.put(xObjectName, pdImageXObject);
        }
        return images;
    }

    public List<BufferedImage> extractImages() throws IOException {
        ArrayList<BufferedImage> imgs = new ArrayList<BufferedImage>();
        Iterator iter = this.document.getPages().iterator();
        while (iter.hasNext()) {
            try {
                Collection<PDImageXObject> images = this.getImagesFromResources(((PDPage)iter.next()).getResources()).values();
                for (PDImageXObject pdImageXObject : images) {
                    imgs.add(pdImageXObject.getImage());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return imgs;
    }
}

