/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.util;

import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;

public class MergeUtil {
    private static final String MERGE = "merge";

    private MergeUtil() {
    }

    public static File mergePdf(List<File> pdfs) throws IOException {
        File tempDir = null;
        try {
            tempDir = FileUtil.createTempDirectory(MERGE);
            File dst = FileUtil.createTempFile(MERGE, ".pdf");
            PDFMergerUtility merger = new PDFMergerUtility();
            for (File file : pdfs) {
                merger.addSource(file);
            }
            merger.setDestinationFileName(dst.getAbsolutePath());
            MemoryUsageSetting memoryUsage = MemoryUsageSetting.setupTempFileOnly();
            memoryUsage.setTempDir(tempDir);
            merger.mergeDocuments(memoryUsage);
            File file = dst;
            return file;
        }
        finally {
            FileUtil.delete(tempDir);
        }
    }
}

