/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.util;

import com.logicaldoc.util.io.FileUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class IconSelector {
    private static Set<String> availableIcons = new HashSet<String>();
    private static Map<String, String> aliases = new HashMap<String, String>();

    static {
        aliases.put("vsdx", "vsd");
        aliases.put("mkd", "md");
        aliases.put("mdwn", "md");
        aliases.put("mdown", "md");
        aliases.put("mdtxt", "md");
        aliases.put("mdtext", "md");
        aliases.put("markdown", "md");
    }

    private IconSelector() {
        throw new IllegalStateException("Utility class");
    }

    public static Set<String> getAvailableIcons() {
        return availableIcons;
    }

    public static String selectIcon(String ext) {
        String icon = ext = IconSelector.normalizeExtension(ext);
        if (aliases.containsKey(ext)) {
            icon = aliases.get(ext);
        }
        if (!availableIcons.contains(icon)) {
            icon = "blank";
        }
        return icon;
    }

    private static String normalizeExtension(String ext) {
        if (ext != null) {
            ext = ext.contains(".") ? FileUtil.getExtension(ext).toLowerCase() : ext.toLowerCase();
        }
        return ext;
    }
}

