/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.util;

import com.logicaldoc.core.util.DbcpConfiguration;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool
implements DataSource,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPool.class);
    private DataSource wrappedDataSource;
    private HikariConfig hikariConfig;
    private DbcpConfiguration dbcpConfig;
    private String implementation;

    public DataSource getWrappedDataSource() {
        if (this.wrappedDataSource == null) {
            log.info("Instantiating connection pool {}", (Object)this.implementation);
            if ("dbcp".equals(this.implementation)) {
                BasicDataSource ds = new BasicDataSource();
                ds.setMaxTotal(this.dbcpConfig.getMaxTotal());
                ds.setMaxIdle(this.dbcpConfig.getMaxIdle());
                ds.setInitialSize(this.dbcpConfig.getInitialSize());
                ds.setTestOnBorrow(this.dbcpConfig.isTestOnBorrow());
                ds.setDurationBetweenEvictionRuns(Duration.ofMillis(this.dbcpConfig.getTimeBetweenEvictionRunsMillis()));
                ds.setNumTestsPerEvictionRun(this.dbcpConfig.getNumTestsPerEvictionRun());
                ds.setTestWhileIdle(this.dbcpConfig.isTestWhileIdle());
                ds.setPassword(this.dbcpConfig.getPassword());
                ds.setUrl(this.dbcpConfig.getUrl());
                ds.setUsername(this.dbcpConfig.getUsername());
                ds.setValidationQuery(this.dbcpConfig.getValidationQuery());
                if (StringUtils.isNotEmpty((CharSequence)this.dbcpConfig.getConnectionInitSqls())) {
                    String[] sqls = this.dbcpConfig.getConnectionInitSqls().split(";");
                    ds.setConnectionInitSqls(Arrays.asList(sqls));
                }
                this.wrappedDataSource = ds;
            } else {
                this.wrappedDataSource = new HikariDataSource(this.hikariConfig);
            }
        }
        return this.wrappedDataSource;
    }

    public void setHikariConfig(HikariConfig hikaryConfig) {
        this.hikariConfig = hikaryConfig;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getWrappedDataSource().getLogWriter();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getWrappedDataSource().unwrap(iface);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getWrappedDataSource().setLogWriter(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getWrappedDataSource().isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getWrappedDataSource().getConnection();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getWrappedDataSource().setLoginTimeout(seconds);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getWrappedDataSource().getConnection(username, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getWrappedDataSource().getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getWrappedDataSource().getParentLogger();
    }

    public void init() {
        this.getWrappedDataSource();
    }

    @Override
    public void close() throws IOException {
        DataSource dataSource = this.getWrappedDataSource();
        if (dataSource instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)dataSource);
            closeable.close();
        }
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public void setDbcpConfig(DbcpConfiguration dbcpConfig) {
        this.dbcpConfig = dbcpConfig;
    }
}

