/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.transfer;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.communication.SystemMessage;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.util.UserUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipImport {
    protected User user;
    private static final Logger log = LoggerFactory.getLogger(ZipImport.class);
    protected File zipFile;
    private boolean notifyUser = true;
    protected String sessionId = null;
    protected Document docVo = null;
    protected String fileNameCharset = "UTF-8";

    public ZipImport(Document docVo, String fileNameCharset) {
        this.docVo = docVo;
        if (fileNameCharset != null) {
            this.fileNameCharset = fileNameCharset;
        }
    }

    public void process(File zipsource, Folder parent, long userId, String sessionId) throws PersistenceException {
        block23: {
            this.zipFile = zipsource;
            this.sessionId = sessionId;
            UserDAO userDao = Context.get(UserDAO.class);
            this.user = (User)userDao.findById(userId);
            File dir = this.prepareUnzipDir(userId);
            try {
                try {
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (ZipUtil zipUtil = new ZipUtil();){
                        zipUtil.unzip(this.zipFile, dir);
                        File[] files = dir.listFiles();
                        this.addEntries(parent, files);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                    try {
                        FileUtils.deleteDirectory(dir);
                    }
                    catch (IOException e2) {
                        log.warn("Cannot delete temporary folder {}", (Object)dir.getPath());
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    FileUtils.deleteDirectory(dir);
                }
                catch (IOException e) {
                    log.warn("Cannot delete temporary folder {}", (Object)dir.getPath());
                }
                throw throwable;
            }
            try {
                FileUtils.deleteDirectory(dir);
            }
            catch (IOException e) {
                log.warn("Cannot delete temporary folder {}", (Object)dir.getPath());
            }
        }
        if (this.notifyUser) {
            try {
                this.sendNotificationMessage();
            }
            catch (Exception e) {
                log.warn("Cannot notify zip import", e);
            }
        }
    }

    private void addEntries(Folder parentFolder, File[] files) {
        int i = 0;
        while (i < files.length) {
            if (StringUtils.isNotEmpty(files[i].getName()) || StringUtils.isNotEmpty(FileUtil.getBaseName(files[i].getName()))) {
                try {
                    this.addEntry(files[i], parentFolder);
                }
                catch (PersistenceException e) {
                    log.error("Error adding entry {}", (Object)files[i].getName());
                    log.error(e.getMessage(), e);
                }
            }
            ++i;
        }
    }

    private File prepareUnzipDir(long userId) {
        File dir = UserUtil.getUserResource(userId, "unzip");
        if (dir.exists()) {
            try {
                FileUtils.deleteDirectory(dir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            FileUtils.forceMkdir(dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dir;
    }

    public void process(String zipsource, Folder parent, long userId, String sessionId) throws PersistenceException {
        File srcfile = new File(zipsource);
        this.process(srcfile, parent, userId, sessionId);
    }

    protected void addEntry(File file, Folder parent) throws PersistenceException {
        block6: {
            Session session;
            block5: {
                FolderDAO dao = Context.get(FolderDAO.class);
                String folderName = file.getName();
                FolderHistory transaction = new FolderHistory();
                transaction.setUser(this.user);
                transaction.setSessionId(this.sessionId);
                session = SessionManager.get().get(this.sessionId);
                transaction.setSession(session);
                if (!file.isDirectory()) break block5;
                Folder folderVO = new Folder();
                folderVO.setName(folderName);
                Folder folder = dao.create(parent, folderVO, true, transaction);
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (StringUtils.isNotEmpty(files[i].getName()) || StringUtils.isNotEmpty(FileUtil.getBaseName(files[i].getName()))) {
                        this.addEntry(files[i], folder);
                    }
                    ++i;
                }
                break block6;
            }
            if (file.length() <= 0L) break block6;
            DocumentManager docManager = Context.get(DocumentManager.class);
            try {
                DocumentHistory history = new DocumentHistory();
                history.setEvent(DocumentEvent.STORED);
                history.setComment("");
                history.setUser(this.user);
                history.setSessionId(this.sessionId);
                if (session != null) {
                    history.setSession(session);
                }
                Document doc = new Document(this.docVo);
                doc.setId(0L);
                doc.setFolder(parent);
                docManager.create(file, doc, history);
            }
            catch (Exception e) {
                log.error("InMemoryZipImport addEntry failed", e);
            }
        }
    }

    protected void sendNotificationMessage() {
        SystemMessageDAO smdao = Context.get(SystemMessageDAO.class);
        Date now = new Date();
        Recipient recipient = new Recipient();
        recipient.setName(this.user.getUsername());
        recipient.setAddress(this.user.getUsername());
        recipient.setType(0);
        recipient.setMode("message");
        HashSet<Recipient> recipients = new HashSet<Recipient>();
        recipients.add(recipient);
        SystemMessage sysmess = new SystemMessage();
        sysmess.setAuthor("SYSTEM");
        sysmess.setRecipients(recipients);
        ResourceBundle bundle = ResourceBundle.getBundle("i18n.messages", this.user.getLocale());
        sysmess.setSubject(bundle.getString("zip.import.subject"));
        String message = bundle.getString("zip.import.body");
        String body = MessageFormat.format(message, this.zipFile != null ? this.zipFile.getName() : "");
        sysmess.setMessageText(body);
        sysmess.setSentDate(now);
        sysmess.setConfirmation(0);
        sysmess.setPrio(0);
        sysmess.setDateScope(1);
        try {
            smdao.store(sysmess);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public boolean isNotifyUser() {
        return this.notifyUser;
    }

    public void setNotifyUser(boolean notifyUser) {
        this.notifyUser = notifyUser;
    }
}

