/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.transfer;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderEvent;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipExport {
    private static final Logger log = LoggerFactory.getLogger(ZipExport.class);
    private ZipArchiveOutputStream zos = null;
    private long userId = -1L;
    private boolean allLevel = false;
    private long startFolderId = 4L;

    public ByteArrayOutputStream process(FolderHistory transaction, boolean pdfConversion) throws PersistenceException {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder folder = folderDao.findFolder(transaction.getFolderId());
        this.userId = transaction.getUserId();
        this.startFolderId = folder.getId();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.zos = new ZipArchiveOutputStream((OutputStream)bos);
        this.zos.setMethod(8);
        this.zos.setEncoding("UTF-8");
        this.zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        this.zos.setUseLanguageEncodingFlag(true);
        try {
            this.appendChildren(folder, 0, pdfConversion, transaction.getSessionId());
        }
        finally {
            try {
                this.zos.flush();
                this.zos.close();
            }
            catch (Exception exception) {}
        }
        transaction.setEvent(FolderEvent.EXPORTED);
        folderDao.saveFolderHistory(folder, transaction);
        return bos;
    }

    public ByteArrayOutputStream process(Long[] docIds, boolean pdfConversion, DocumentHistory transaction) throws PersistenceException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.process(docIds, bos, pdfConversion, transaction);
        return bos;
    }

    public void process(Long[] docIds, OutputStream out, boolean pdfConversion, DocumentHistory transaction) throws PersistenceException {
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        FolderDAO fdao = Context.get(FolderDAO.class);
        this.zos = new ZipArchiveOutputStream(out);
        this.zos.setEncoding("UTF-8");
        this.zos.setMethod(8);
        this.zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        this.zos.setUseLanguageEncodingFlag(true);
        try {
            Long[] longArray = docIds;
            int n = docIds.length;
            int n2 = 0;
            while (n2 < n) {
                long id = longArray[n2];
                Document doc = (Document)ddao.findById(id);
                if (transaction == null || transaction.getUserId() == 0L || fdao.isDownloadllowed(doc.getFolder().getId(), transaction.getUserId())) {
                    boolean convertToPdf = pdfConversion;
                    if (doc.getDocRef() != null && "pdf".equals((doc = (Document)ddao.findById(doc.getDocRef())).getDocRefType())) {
                        convertToPdf = true;
                    }
                    this.addDocument("", doc, convertToPdf);
                    try {
                        this.zos.flush();
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                    this.saveHistory(transaction, doc);
                }
                ++n2;
            }
        }
        finally {
            try {
                this.zos.flush();
                this.zos.close();
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
    }

    private void saveHistory(DocumentHistory transaction, Document doc) {
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        if (transaction != null) {
            DocumentHistory t = new DocumentHistory(transaction);
            transaction.setEvent(DocumentEvent.DOWNLOADED);
            try {
                ddao.saveDocumentHistory(doc, t);
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    public void setAllLevel(boolean level) {
        this.allLevel = level;
    }

    protected void appendChildren(Folder folder, int depth, boolean pdfConversion, String sid) throws PersistenceException {
        if (this.allLevel || depth < 1) {
            this.addFolderDocuments(folder, pdfConversion, sid);
            FolderDAO folderDao = Context.get(FolderDAO.class);
            List<Folder> children = folderDao.findByUserId(this.userId, folder.getId());
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                this.appendChildren((Folder)iter.next(), depth + 1, pdfConversion, sid);
            }
        }
    }

    protected void addFolderDocuments(Folder folder, boolean pdfConversion, String sid) throws PersistenceException {
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        List<Document> docs = ddao.findByFolder(folder.getId(), null);
        Iterator iterator = docs.iterator();
        while (iterator.hasNext()) {
            Document document;
            Document doc = document = (Document)iterator.next();
            boolean convertToPdf = pdfConversion;
            if (doc.getDocRef() != null && "pdf".equals((doc = (Document)ddao.findById(doc.getDocRef())).getDocRefType())) {
                convertToPdf = true;
            }
            this.addDocument(this.getZipEntryPath(folder), doc, convertToPdf);
        }
    }

    private String adjustFileNameForWindows(String src) {
        Object newName = src.replace("/", "").replace("\\", "");
        if (((String)newName).length() > 250) {
            String ext = FileUtil.getExtension((String)newName);
            int maxSize = 250 - ext.length() - 1;
            String name = FileUtil.getBaseName((String)newName).substring(0, maxSize);
            newName = name + "." + ext;
        }
        return newName;
    }

    private void addDocument(String path, Document document, boolean pdfConversion) {
        Object manager;
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(document, null, null);
        if (pdfConversion && !"pdf".equals(FileUtil.getExtension(document.getFileName().toLowerCase()))) {
            manager = Context.get(FormatConverterManager.class);
            try {
                ((FormatConverterManager)manager).convertToPdf(document, null);
            }
            catch (IOException e) {
                log.warn(e.getMessage(), e);
                return;
            }
            resource = store.getResourceName(document, null, "conversion.pdf");
        }
        try {
            try {
                manager = null;
                Object var7_10 = null;
                try (BufferedInputStream bis = new BufferedInputStream(store.getStream(document.getId(), resource));){
                    int len;
                    Object fileName = document.getFileName();
                    if (pdfConversion) {
                        fileName = FileUtil.getBaseName((String)fileName) + ".pdf";
                    }
                    ZipEntry entry = new ZipEntry(path + this.adjustFileNameForWindows((String)fileName));
                    entry.setMethod(8);
                    this.zos.putArchiveEntry(new ZipArchiveEntry(entry));
                    while ((len = bis.read()) != -1) {
                        this.zos.write(len);
                    }
                }
                catch (Throwable throwable) {
                    if (manager == null) {
                        manager = throwable;
                    } else if (manager != throwable) {
                        ((Throwable)manager).addSuppressed(throwable);
                    }
                    throw manager;
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
                try {
                    this.zos.closeArchiveEntry();
                }
                catch (IOException e2) {
                    log.warn(e2.getMessage());
                }
            }
        }
        finally {
            try {
                this.zos.closeArchiveEntry();
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
        }
    }

    private String getZipEntryPath(Folder folder) throws PersistenceException {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        long rootId = folderDao.findRoot(folder.getTenantId()).getId();
        if (folder.getId() == rootId) {
            return "";
        }
        List<Folder> folders = folderDao.findParents(folder.getId());
        folders.add(folder);
        Collections.reverse(folders);
        ArrayList<String> folderNames = new ArrayList<String>();
        int i = 0;
        while (i < folders.size()) {
            Folder f = folders.get(i);
            if (f.getId() == this.startFolderId) break;
            folderNames.add(f.getName());
            ++i;
        }
        Collections.reverse(folderNames);
        StringBuilder path = new StringBuilder("");
        for (String name : folderNames) {
            path.append(name);
            path.append("/");
        }
        return path.toString();
    }
}

