/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.transfer;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.transfer.ZipImport;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryZipImport
extends ZipImport {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryZipImport.class);

    public InMemoryZipImport(Document docVo, String charset) {
        super(docVo, charset);
    }

    @Override
    public void process(File zipsource, Folder parent, long userId, String sessionId) {
        this.zipFile = zipsource;
        this.sessionId = sessionId;
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            this.user = (User)userDao.findById(userId);
            this.extractEntries(zipsource, parent, sessionId);
        }
        catch (Exception e) {
            logger.error("InMemoryZipImport process failed", e);
        }
        if (this.isNotifyUser()) {
            this.sendNotificationMessage();
        }
    }

    private void extractEntries(File sourceZipFile, Folder parent, String sessionId) throws PersistenceException {
        FolderDAO fDao = Context.get(FolderDAO.class);
        DocumentManager docManager = Context.get(DocumentManager.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ZipUtil zipUtil = new ZipUtil();){
            zipUtil.setFileNameCharset(this.fileNameCharset);
            List<String> entries = zipUtil.listEntries(sourceZipFile);
            for (String entry : entries) {
                String fileName = FileUtil.getName(entry);
                String title = FileUtil.getBaseName(fileName);
                if (StringUtils.isEmpty(fileName) || StringUtils.isEmpty(title)) continue;
                String relativePath = FileUtil.getPath(entry);
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                if (relativePath.endsWith("/")) {
                    relativePath = relativePath.substring(0, relativePath.length() - 1);
                }
                FolderHistory folderTransaction = new FolderHistory();
                folderTransaction.setSessionId(sessionId);
                folderTransaction.setUser(this.user);
                Folder folder = fDao.createPath(parent, relativePath, true, folderTransaction);
                Document doc = new Document(this.docVo);
                doc.setId(0L);
                doc.setFileName(fileName);
                doc.setFolder(folder);
                DocumentHistory history = new DocumentHistory();
                history.setEvent(DocumentEvent.STORED);
                history.setComment("");
                history.setUser(this.user);
                history.setSessionId(sessionId);
                try {
                    docManager.create(zipUtil.getEntryStream(sourceZipFile, entry), doc, history);
                }
                catch (Exception e) {
                    logger.warn("InMemoryZipImport unable to import ZIP entry {}", (Object)entry, (Object)e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

