/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.ticket;

import com.logicaldoc.core.PersistentObject;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="ld_ticket")
@Cacheable
public class Ticket
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final int DOWNLOAD = 0;
    public static final int PSW_RECOVERY = 1;
    public static final int VIEW = 2;
    @Column(name="ld_ticketid", nullable=false)
    private String ticketId = UUID.randomUUID().toString();
    @Column(name="ld_docid", nullable=false)
    private long docId = 0L;
    @Column(name="ld_suffix")
    private String suffix;
    @Column(name="ld_userid", nullable=false)
    private long userId = -1L;
    @Column(name="ld_type", nullable=false)
    private int type = 0;
    @Column(name="ld_expired", columnDefinition="DATETIME(3)")
    private Date expired = null;
    @Column(name="ld_count", nullable=false)
    private int count = 0;
    @Column(name="ld_maxcount", nullable=true)
    private Integer maxCount;
    @Column(name="ld_enabled", nullable=false)
    private int enabled = 1;
    @Column(name="ld_views", nullable=false)
    private int views = 0;
    @Column(name="ld_maxviews", nullable=true)
    private Integer maxViews;
    @Transient
    private String url;
    @Transient
    private Integer expireHours;

    public long getDocId() {
        return this.docId;
    }

    public void setDocId(long docId) {
        this.docId = docId;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Date getExpired() {
        return this.expired;
    }

    public void setExpired(Date expired) {
        this.expired = expired;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isTicketExpired() {
        return this.enabled == 0 || this.expired != null && new Date().getTime() > this.expired.getTime() || this.maxCount != null && this.maxCount > 0 && this.count >= this.maxCount;
    }

    public boolean isTicketViewExpired() {
        return this.enabled == 0 || this.expired != null && new Date().getTime() > this.expired.getTime() || this.maxViews != null && this.maxViews > 0 && this.views >= this.maxViews;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public int getViews() {
        return this.views;
    }

    public void setViews(int views) {
        this.views = views;
    }

    public Integer getMaxViews() {
        return this.maxViews;
    }

    public void setMaxViews(Integer maxViews) {
        this.maxViews = maxViews;
    }

    public Integer getExpireHours() {
        return this.expireHours;
    }

    public void setExpireHours(Integer expireHours) {
        this.expireHours = expireHours;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ticketId == null ? 0 : this.ticketId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ticket other = (Ticket)obj;
        return !(this.ticketId == null ? other.ticketId != null : !this.ticketId.equals(other.ticketId));
    }
}

