/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.ticket;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.ticket.Ticket;
import com.logicaldoc.core.ticket.TicketDAO;
import com.logicaldoc.util.config.ContextProperties;
import jakarta.transaction.Transactional;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="ticketDAO")
@Transactional
public class HibernateTicketDAO
extends HibernatePersistentObjectDAO<Ticket>
implements TicketDAO {
    private DocumentDAO documentDAO;
    private ContextProperties config;

    public HibernateTicketDAO(DocumentDAO documentDAO, ContextProperties config) {
        super(Ticket.class);
        this.log = LoggerFactory.getLogger(HibernateTicketDAO.class);
        this.documentDAO = documentDAO;
        this.config = config;
    }

    @Override
    public void store(Ticket entity) throws PersistenceException {
        this.store(entity, null);
    }

    @Override
    public void store(Ticket entity, DocumentHistory transaction) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        if (entity.getExpired() == null) {
            int ttl = this.config.getInt("ticket.ttl");
            Calendar cal = Calendar.getInstance();
            cal.add(11, ttl);
            entity.setExpired(cal.getTime());
        }
        if (StringUtils.isEmpty(entity.getSuffix())) {
            entity.setSuffix(null);
        }
        super.store(entity);
        if (transaction != null) {
            transaction.setEvent(DocumentEvent.TICKET_CREATED);
            transaction.setDocId(entity.getDocId());
            transaction.setComment((entity.getType() == 0 ? "Download" : "View") + " ticket " + entity.getTicketId());
            try {
                this.documentDAO.saveDocumentHistory((Document)this.documentDAO.findById(entity.getDocId()), transaction);
            }
            catch (PersistenceException e) {
                this.log.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean deleteByTicketId(String ticketid) {
        if (!this.checkStoringAspect()) {
            return false;
        }
        boolean result = true;
        try {
            Ticket ticket = this.findByTicketId(ticketid);
            if (ticket != null) {
                ticket.setDeleted(1);
                this.saveOrUpdate(ticket);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public Ticket findByTicketId(String ticketid) {
        try {
            List coll = this.findByObjectQuery("from Ticket _ticket where _ticket.ticketId = :ticketid", Map.of("ticketid", ticketid), null);
            Ticket ticket = null;
            if (!coll.isEmpty() && (ticket = (Ticket)coll.iterator().next()).getDeleted() == 0) {
                return ticket;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public boolean deleteByDocId(long docId) {
        if (!this.checkStoringAspect()) {
            return false;
        }
        boolean result = true;
        try {
            List coll = this.findByObjectQuery("from Ticket _ticket where _ticket.docId = :docId", Map.of("docId", docId), null);
            for (Ticket downloadTicket : coll) {
                downloadTicket.setDeleted(1);
                this.saveOrUpdate(downloadTicket);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            result = false;
        }
        return result;
    }

    public void setConfig(ContextProperties config) {
        this.config = config;
    }

    @Override
    public void deleteExpired() {
        if (!this.checkStoringAspect()) {
            return;
        }
        try {
            this.jdbcUpdate("update ld_ticket set ld_deleted=1 where ld_deleted = 0 and ld_expired < :expired", Map.of("expired", new Date()));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
    }

    public DocumentDAO getDocumentDAO() {
        return this.documentDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }
}

