/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.threading;

import com.logicaldoc.core.threading.NamedThreadFactory;
import com.logicaldoc.core.threading.ThreadPoolNotAvailableException;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="threadPools")
public class ThreadPools {
    private static final String THREADPOOL = "threadpool.";
    private static final String TYPE_DEFAULT = "default";
    private static final Logger log = LoggerFactory.getLogger(ThreadPools.class);
    private Map<String, ThreadPoolExecutor> pools = new HashMap<String, ThreadPoolExecutor>();
    @Resource(name="ContextProperties")
    protected ContextProperties config;

    public static ThreadPools get() {
        return Context.get(ThreadPools.class);
    }

    public synchronized ThreadPoolExecutor getPool(String name) throws ThreadPoolNotAvailableException {
        ThreadPoolExecutor pool = this.pools.get(name);
        if (pool != null) {
            if (this.pools.get(name).isShutdown()) {
                throw new ThreadPoolNotAvailableException(name);
            }
        } else {
            int core = this.config.getInt(THREADPOOL + name + ".core", 5);
            int max = this.config.getInt(THREADPOOL + name + ".max", 10);
            int keepalive = this.config.getInt(THREADPOOL + name + ".keepalive", 5);
            String type = this.config.getString(THREADPOOL + name + ".type", TYPE_DEFAULT);
            pool = TYPE_DEFAULT.equals(type) ? new ScheduledThreadPoolExecutor(core, new NamedThreadFactory(name)) : new ThreadPoolExecutor(core, max, keepalive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            this.pools.put(name, pool);
        }
        return pool;
    }

    public <T> Future<T> schedule(Callable<T> task, String poolName, long delay) {
        try {
            ThreadPoolExecutor pool = this.getPool(poolName);
            if (pool instanceof ScheduledExecutorService) {
                ScheduledExecutorService executorService = (ScheduledExecutorService)((Object)pool);
                return executorService.schedule(task, delay, TimeUnit.MILLISECONDS);
            }
            log.debug("Pool {} does not support scheduling so the task has been started immediately", (Object)poolName);
            return this.execute(task, poolName);
        }
        catch (ThreadPoolNotAvailableException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public <T> Future<T> execute(Callable<T> task, String poolName) {
        try {
            ThreadPoolExecutor pool = this.getPool(poolName);
            return pool.submit(task);
        }
        catch (ThreadPoolNotAvailableException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    @PreDestroy
    public void shutdown() {
        log.info("Shutting down {} thread pools", (Object)this.pools.size());
        for (Map.Entry<String, ThreadPoolExecutor> entry : this.pools.entrySet()) {
            log.info("Killing all the threads of pool {}", (Object)entry.getKey());
            ExecutorService pool = entry.getValue();
            pool.shutdownNow();
            try {
                pool.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

