/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.threading;

import com.logicaldoc.util.time.TimeDiff;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyingThread<T>
implements Callable<T> {
    private static final Logger log = LoggerFactory.getLogger(NotifyingThread.class);
    private long startTime = 0L;
    private long endTime = 0L;
    private final Set<ThreadCompleteListener<T>> listeners = new CopyOnWriteArraySet<ThreadCompleteListener<T>>();
    private Throwable error;
    private Callable<T> wrappedCallable;
    private String name;

    public final void addListener(ThreadCompleteListener<T> listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(ThreadCompleteListener<T> listener) {
        this.listeners.remove(listener);
    }

    private final void notifyListeners() {
        for (ThreadCompleteListener<T> listener : this.listeners) {
            listener.completed(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getElapsedTime() {
        long elapsed = 0L;
        if (this.endTime > 0L) {
            elapsed = this.endTime - this.startTime;
        } else if (this.startTime > 0L) {
            elapsed = System.currentTimeMillis() - this.startTime;
        }
        if (elapsed < 0L) {
            elapsed = 0L;
        }
        return elapsed;
    }

    public boolean isOver() {
        return this.endTime > 0L;
    }

    @Override
    public final T call() {
        try {
            this.endTime = 0L;
            this.startTime = System.currentTimeMillis();
            this.error = null;
            log.debug("Thread {} started", (Object)this.getName());
            if (this.wrappedCallable != null) {
                T t = this.wrappedCallable.call();
                return t;
            }
            T t = this.doRun();
            return t;
        }
        catch (Exception t) {
            this.error = t;
            log.debug("Thread {} ended in error after {}", this.getName(), TimeDiff.printDuration(this.getElapsedTime()), t);
        }
        finally {
            this.endTime = System.currentTimeMillis();
            this.notifyListeners();
        }
        return null;
    }

    public NotifyingThread(String name) {
        this.name = name;
    }

    public NotifyingThread(Callable<T> wrappedCallable, String name) {
        this.wrappedCallable = wrappedCallable;
        this.name = name;
    }

    public T doRun() {
        return null;
    }

    public Throwable getError() {
        return this.error;
    }

    public static interface ThreadCompleteListener<T> {
        public void completed(NotifyingThread<T> var1);
    }
}

