/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.task;

import com.logicaldoc.core.task.Task;
import com.logicaldoc.util.config.ContextProperties;
import jakarta.annotation.Resource;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;

public class TaskTrigger
implements FactoryBean<Trigger>,
BeanNameAware,
InitializingBean {
    protected Logger log = LoggerFactory.getLogger(TaskTrigger.class);
    private SimpleTriggerFactoryBean simpleTrigger = null;
    private CronTriggerFactoryBean cronTrigger = null;
    public static final String MODE_CRON = "cron";
    public static final String MODE_SIMPLE = "simple";
    @Resource(name="ContextProperties")
    protected ContextProperties config;
    private Task task;
    private JobDetail jobDetail;

    public Task getTask() {
        return this.task;
    }

    public String getName() {
        if (this.task != null) {
            return this.task.getName();
        }
        return "";
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public SimpleTriggerFactoryBean getSimpleTrigger() {
        return this.simpleTrigger;
    }

    public CronTriggerFactoryBean getCronTrigger() {
        return this.cronTrigger;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setBeanName(String beanName) {
    }

    public Trigger getObject() {
        if (MODE_SIMPLE.equals(this.config.getProperty("schedule.mode." + this.getName()))) {
            if (this.simpleTrigger == null) {
                this.simpleTrigger = new SimpleTriggerFactoryBean();
                this.simpleTrigger.setName(this.getName());
                this.simpleTrigger.setRepeatInterval(Long.parseLong(this.config.getProperty("schedule.interval." + this.getName())));
                this.simpleTrigger.setStartDelay(Long.parseLong(this.config.getProperty("schedule.delay." + this.getName())));
                this.simpleTrigger.setJobDetail(this.jobDetail);
                this.simpleTrigger.afterPropertiesSet();
            }
            this.cronTrigger = null;
            return this.simpleTrigger.getObject();
        }
        if (this.cronTrigger == null) {
            this.cronTrigger = new CronTriggerFactoryBean();
            this.cronTrigger.setName(this.getName());
            this.cronTrigger.setCronExpression(this.config.getProperty("schedule.cron." + this.getName()));
            this.cronTrigger.setJobDetail(this.jobDetail);
            try {
                this.cronTrigger.afterPropertiesSet();
            }
            catch (Exception e) {
                this.log.warn(e.getMessage(), e);
            }
        }
        this.simpleTrigger = null;
        return this.cronTrigger.getObject();
    }

    public Class<?> getObjectType() {
        try {
            if (MODE_SIMPLE.equals(this.config.getProperty("schedule.mode." + this.getName()))) {
                return SimpleTrigger.class;
            }
            return CronTrigger.class;
        }
        catch (Exception t) {
            return SimpleTrigger.class;
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public void reload() {
        this.cronTrigger = null;
        this.simpleTrigger = null;
        this.getObject();
    }

    public long getRepeatInterval() {
        SimpleTrigger triggerObject = this.simpleTrigger.getObject();
        if (triggerObject != null) {
            return triggerObject.getRepeatInterval();
        }
        return -1L;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }
}

