/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.task;

import com.logicaldoc.core.task.TaskTrigger;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScheduling {
    private static final Logger log = LoggerFactory.getLogger(TaskScheduling.class);
    private String taskName;
    private String mode = "simple";
    private long delay = 1000L;
    private long interval = 60000L;
    private String cronExpression = "* 10 * * * ? *";
    private Date previousFireTime;
    private long maxLength = -1L;
    private boolean enabled = true;

    public TaskScheduling(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    public Date getNextFireTime() {
        Date nextFire = null;
        Object trigger = Context.get(this.taskName + "Trigger");
        if (trigger instanceof Trigger) {
            Trigger trgr = (Trigger)trigger;
            nextFire = this.previousFireTime != null ? trgr.getFireTimeAfter(this.previousFireTime) : trgr.getNextFireTime();
        }
        return nextFire;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void load() throws IOException, ParseException {
        ContextProperties config = Context.get().getProperties();
        this.enabled = config.getBoolean("schedule.enabled." + this.taskName, false);
        this.setCronExpression(config.getProperty("schedule.cron." + this.taskName));
        this.setMode(config.getProperty("schedule.mode." + this.taskName));
        try {
            this.maxLength = Long.parseLong(config.getProperty("schedule.length." + this.taskName));
            this.interval = Long.parseLong(config.getProperty("schedule.interval." + this.taskName));
            this.delay = Long.parseLong(config.getProperty("schedule.delay." + this.taskName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() throws IOException, ParseException {
        Scheduler scheduler = Context.get(Scheduler.class);
        TaskTrigger trigger = (TaskTrigger)Context.get("&" + this.taskName + "Trigger");
        String expression = this.getCronExpression();
        ContextProperties config = Context.get().getProperties();
        config.setProperty("schedule.cron." + this.taskName, expression);
        config.setProperty("schedule.enabled." + this.taskName, this.enabled ? "true" : "false");
        config.setProperty("schedule.length." + this.taskName, Long.toString(this.maxLength));
        config.setProperty("schedule.mode." + this.taskName, this.getMode());
        config.setProperty("schedule.delay." + this.taskName, Long.toString(this.delay));
        config.setProperty("schedule.interval." + this.taskName, Long.toString(this.interval));
        config.write();
        trigger.reload();
        try {
            TriggerKey key = new TriggerKey(this.taskName, "DEFAULT");
            Date date = scheduler.rescheduleJob(key, trigger.getObject());
            if (date != null) {
                log.info("Rescheduled the task {}; next estimated fire time is {}", (Object)this.taskName, (Object)date);
            } else {
                log.warn("Unable to reschedule the task {}", (Object)this.taskName);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        this.load();
    }

    boolean isExpired() {
        long diffSeconds;
        if (this.previousFireTime == null || this.getMaxLength() <= 0L) {
            return false;
        }
        Date now = new Date();
        long diff = now.getTime() - this.previousFireTime.getTime();
        if (diff < 0L) {
            diff = -diff;
        }
        return (diffSeconds = diff / 1000L) > this.getMaxLength();
    }

    public String toString() {
        return this.getCronExpression();
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getDelaySeconds() {
        return this.delay / 1000L;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setDelaySeconds(long delay) {
        this.delay = delay * 1000L;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getIntervalSeconds() {
        return this.interval / 1000L;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setIntervalSeconds(long interval) {
        this.interval = interval * 1000L;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }
}

