/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.task;

import com.logicaldoc.core.document.TagsProcessor;
import com.logicaldoc.core.searchengine.IndexOptimizer;
import com.logicaldoc.core.searchengine.indexer.IndexerTask;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import java.util.ArrayList;
import java.util.Collection;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="taskManager")
public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);

    Collection<Task> getTasks(ApplicationContext context) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        tasks.add((Task)context.getBean(IndexOptimizer.class.getAnnotation(Component.class).value()));
        tasks.add((Task)context.getBean(IndexerTask.class.getAnnotation(Component.class).value()));
        tasks.add((Task)context.getBean(TagsProcessor.class.getAnnotation(Component.class).value()));
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "Task");
        for (Extension extension : exts) {
            Object name = extension.getParameter("name").valueAsString();
            if (!context.containsBean((String)name)) {
                name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
            }
            tasks.add((Task)context.getBean((String)name));
        }
        return tasks;
    }

    public Collection<Task> getTasks() {
        Context context = Context.get();
        ArrayList<Task> tasks = new ArrayList<Task>();
        tasks.add((Task)context.getBean(IndexOptimizer.class.getAnnotation(Component.class).value()));
        tasks.add((Task)context.getBean(IndexerTask.class.getAnnotation(Component.class).value()));
        tasks.add((Task)context.getBean(TagsProcessor.class.getAnnotation(Component.class).value()));
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "Task");
        for (Extension extension : exts) {
            String name = extension.getParameter("name").valueAsString();
            tasks.add((Task)context.getBean(name));
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Collection<Task> tasks = this.getTasks();
        for (Task task : tasks) {
            task.interrupt();
        }
        boolean running = true;
        while (running) {
            running = false;
            for (Task task : tasks) {
                if (!task.isRunning()) continue;
                running = true;
                break;
            }
            TaskManager taskManager = this;
            synchronized (taskManager) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        log.info("All tasks are idle");
    }
}

