/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.task;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.lock.LockManager;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.system.SystemLoadMonitor;
import com.logicaldoc.core.task.TaskException;
import com.logicaldoc.core.task.TaskListener;
import com.logicaldoc.core.task.TaskScheduling;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task
implements Runnable {
    protected Logger log = LoggerFactory.getLogger(Task.class);
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_STOPPING = 2;
    private int status = 0;
    protected long size = 0L;
    private long progress = 0L;
    private TaskScheduling scheduling;
    private String name;
    protected boolean interruptRequested = false;
    private List<TaskListener> taskListeners = Collections.synchronizedList(new ArrayList());
    protected Throwable lastRunError = null;
    @Resource(name="ContextProperties")
    protected ContextProperties config;
    @Resource(name="EMailSender")
    protected EMailSender sender = null;
    @Resource(name="userDAO")
    protected UserDAO userDao = null;
    @Resource(name="lockManager")
    protected LockManager lockManager;
    @Resource(name="systemLoadMonitor")
    protected SystemLoadMonitor systemLoadMonitor;
    protected boolean sendActivityReport = false;
    private String reportRecipients = null;
    protected String transactionId = null;
    private Random random = new Random();

    protected Task(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    private synchronized void setStatus(int status) {
        if (status != 0 && status != 1 && status != 2) {
            throw new InvalidParameterException("Invalid status value");
        }
        boolean needNotification = this.status != status;
        this.status = status;
        if (needNotification) {
            for (TaskListener listener : this.taskListeners) {
                listener.statusChanged(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void next() {
        this.setProgress(this.progress + 1L);
        this.getLock();
        if (this.systemLoadMonitor != null) {
            boolean overload = false;
            while (this.systemLoadMonitor.isAverageCpuOverLoaded() && !this.interruptRequested) {
                if (!overload) {
                    overload = true;
                    this.log.info("Execution paused because of system overload");
                }
                this.getLock();
                Task task = this;
                synchronized (task) {
                    try {
                        this.wait((long)(1 + this.random.nextInt(20)) * 1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.checkExpiration();
            }
            if (overload) {
                this.log.info("Execution resumed after system overload");
            }
        }
    }

    private void getLock() {
        if (this.lockManager != null) {
            this.lockManager.get(this.getName(), this.transactionId);
        }
    }

    protected synchronized void setProgress(long progress) {
        try {
            if (progress > this.getSize() || progress < 0L) {
                return;
            }
            try {
                boolean needNotification = this.progress != progress;
                this.progress = progress;
                if (needNotification) {
                    for (TaskListener listener : this.taskListeners) {
                        listener.progressChanged(progress);
                    }
                }
            }
            catch (Exception exception) {}
        }
        finally {
            this.checkExpiration();
        }
    }

    private void checkExpiration() {
        if (this.getScheduling().isExpired()) {
            this.log.warn("The timeout has been reached, the elaboration is being interrupted");
            this.interrupt();
        }
    }

    @Override
    public void run() {
        if (!RunLevel.current().aspectEnabled("scheduledTasks")) {
            this.log.debug("Aspect Scheduled Tasks not enabled");
            return;
        }
        if (!this.getScheduling().isEnabled()) {
            this.log.debug("Task {} is disabled", (Object)this.getName());
            return;
        }
        if (this.getStatus() != 0) {
            this.log.debug("Task {} is already running", (Object)this.getName());
            return;
        }
        this.log.info("Task {} started", (Object)this.getName());
        this.interruptRequested = false;
        this.setStatus(1);
        this.getScheduling().setPreviousFireTime(new Date());
        this.setProgress(0L);
        this.lastRunError = null;
        try {
            try {
                this.transactionId = UUID.randomUUID().toString();
                if (this.isConcurrent() || this.lockManager != null && this.lockManager.get(this.getName(), this.transactionId)) {
                    this.runTask();
                }
            }
            catch (InterruptedException ie) {
                this.log.error("The task gets interrupted");
                Thread.currentThread().interrupt();
                try {
                    if (this.lockManager != null) {
                        this.lockManager.release(this.getName(), this.transactionId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setStatus(0);
                this.interruptRequested = false;
                this.saveWork();
                this.log.info("Task {} finished", (Object)this.getName());
                if (this.isSendActivityReport() && StringUtils.isNotEmpty(this.getReportRecipients())) {
                    this.notifyReport();
                }
                this.transactionId = null;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), e);
                this.log.error("The task is stopped");
                this.lastRunError = e;
                try {
                    if (this.lockManager != null) {
                        this.lockManager.release(this.getName(), this.transactionId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setStatus(0);
                this.interruptRequested = false;
                this.saveWork();
                this.log.info("Task {} finished", (Object)this.getName());
                if (this.isSendActivityReport() && StringUtils.isNotEmpty(this.getReportRecipients())) {
                    this.notifyReport();
                }
                this.transactionId = null;
            }
        }
        finally {
            try {
                if (this.lockManager != null) {
                    this.lockManager.release(this.getName(), this.transactionId);
                }
            }
            catch (Exception exception) {}
            this.setStatus(0);
            this.interruptRequested = false;
            this.saveWork();
            this.log.info("Task {} finished", (Object)this.getName());
            if (this.isSendActivityReport() && StringUtils.isNotEmpty(this.getReportRecipients())) {
                this.notifyReport();
            }
            this.transactionId = null;
        }
    }

    public synchronized void interrupt() {
        if (this.isRunning()) {
            this.interruptRequested = true;
            this.setStatus(2);
        }
    }

    public synchronized boolean isInterrupted() {
        return this.getStatus() == 0;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized long getProgress() {
        return this.progress;
    }

    public int getCompletionPercentage() {
        if (this.isIndeterminate()) {
            if (this.getStatus() == 0) {
                return 0;
            }
            return 1;
        }
        if (this.getSize() == 0L) {
            return 0;
        }
        return (int)Math.round((double)this.progress / (double)this.getSize() * 100.0);
    }

    public synchronized boolean isRunning() {
        return this.getStatus() == 1;
    }

    public void saveWork() {
    }

    public TaskScheduling getScheduling() {
        if (this.scheduling == null) {
            this.scheduling = new TaskScheduling(this.getName());
            try {
                this.scheduling.load();
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        }
        return this.scheduling;
    }

    public synchronized void addTaskListener(TaskListener listener) {
        if (!this.taskListeners.contains(listener)) {
            this.taskListeners.add(listener);
        }
    }

    public synchronized void removeTaskListener(TaskListener listener) {
        if (this.taskListeners.contains(listener)) {
            this.taskListeners.remove(listener);
        }
    }

    public void notifyReport() {
        StringTokenizer st = new StringTokenizer(this.getReportRecipients(), ", ;", false);
        while (st.hasMoreTokens()) {
            String userId = st.nextToken();
            User recipient = null;
            try {
                recipient = (User)this.userDao.findById(Long.parseLong(userId));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (PersistenceException e1) {
                this.log.error(e1.getMessage(), e1);
            }
            if (recipient == null || StringUtils.isEmpty(recipient.getEmail())) continue;
            EMail email = new EMail();
            email.setHtml(1);
            email.setLocale(recipient.getLocale());
            HashSet<Recipient> rec = new HashSet<Recipient>();
            Recipient r = new Recipient();
            r.setAddress(recipient.getEmail());
            r.setType(1);
            r.setMode("TO");
            rec.add(r);
            email.setRecipients(rec);
            HashMap<String, Object> dictionary = new HashMap<String, Object>();
            dictionary.put("locale", recipient.getLocale());
            dictionary.put("task", I18N.message("task.name." + this.name, recipient.getLocale()));
            dictionary.put("started", this.scheduling.getPreviousFireTime());
            dictionary.put("ended", new Date());
            dictionary.put("error", this.lastRunError != null ? this.lastRunError.getMessage() : null);
            dictionary.put("report", this.prepareReport(recipient.getLocale()).replace("\\n", "<br />"));
            try {
                this.sender.send(email, "task.report", dictionary);
                this.log.info("Report sent to: {}", (Object)recipient.getEmail());
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), e);
            }
        }
    }

    protected String prepareReport(Locale locale) {
        return "";
    }

    protected abstract void runTask() throws TaskException, InterruptedException;

    public abstract boolean isIndeterminate();

    public abstract boolean isConcurrent();

    public String getReportRecipients() {
        return this.reportRecipients;
    }

    public ContextProperties getConfig() {
        return this.config;
    }

    public void save() throws IOException, ParseException {
        this.getScheduling().save();
        ContextProperties props = Context.get().getProperties();
        props.setProperty("task.recipients." + this.name, this.getReportRecipients());
        props.setProperty("task.sendreport." + this.name, this.isSendActivityReport() ? "true" : "false");
        props.write();
    }

    public boolean isSendActivityReport() {
        return this.sendActivityReport;
    }

    public void setSendActivityReport(boolean sendActivityReport) {
        this.sendActivityReport = sendActivityReport;
    }

    public void setReportRecipients(String reportRecipients) {
        this.reportRecipients = reportRecipients;
    }

    public boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    @PostConstruct
    protected void init() {
        this.sendActivityReport = this.config.getBoolean("task.sendreport." + this.name);
        this.reportRecipients = this.config.getProperty("task.recipients." + this.name);
    }
}

