/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.task;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.task.DocumentProcessorStats;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.util.spring.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public abstract class DocumentProcessorCallable<T extends DocumentProcessorStats>
implements Callable<T> {
    protected List<Long> docIds = new ArrayList<Long>();
    protected boolean completed = false;
    protected boolean interrupt = false;
    protected Logger log;
    protected Task task;
    protected T stats;

    protected DocumentProcessorCallable(List<Long> docIds, Task task, Logger log) {
        this.docIds = docIds;
        this.log = log;
        this.task = task;
        this.stats = this.prepareStats();
    }

    @Override
    public T call() throws Exception {
        User user = this.loadUser();
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        for (Long id : this.docIds) {
            this.log.debug("Process document {}", (Object)id);
            try {
                Document doc = (Document)documentDao.findById(id);
                documentDao.initialize(doc);
                this.processDocument(doc, user);
                ((DocumentProcessorStats)this.stats).setProcessed(((DocumentProcessorStats)this.stats).getProcessed() + 1L);
                this.task.next();
                this.log.debug("Processed document {}", (Object)doc);
            }
            catch (Exception e) {
                ((DocumentProcessorStats)this.stats).setErrors(((DocumentProcessorStats)this.stats).getErrors() + 1L);
                this.log.error("Error processing document {}", (Object)id);
                this.log.error(e.getMessage(), e);
            }
            if (this.interrupt) break;
        }
        return this.stats;
    }

    private User loadUser() throws PersistenceException {
        User user = Context.get(UserDAO.class).findByUsername(this.getDefaultUser());
        if (user == null) {
            user = Context.get(UserDAO.class).findByUsername("_system");
        }
        return user;
    }

    protected String getDefaultUser() {
        return "_system";
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void interrupt() {
        this.interrupt = true;
    }

    protected abstract void processDocument(Document var1, User var2) throws PersistenceException, IOException;

    protected abstract T prepareStats();
}

