/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.task;

import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.task.DummyScheduler;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskManager;
import java.util.ArrayList;
import java.util.Collection;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class DefaultSchedulerFactory
extends SchedulerFactoryBean
implements ApplicationContextAware {
    private static final String ASPECT_DISABLED = "Aspect disabled";
    private static final String SCHEDULED_TASKS = "scheduledTasks";
    private static final Logger log = LoggerFactory.getLogger(DefaultSchedulerFactory.class);

    public void start() throws SchedulingException {
        if (RunLevel.current().aspectEnabled(SCHEDULED_TASKS)) {
            super.start();
        } else {
            log.warn(ASPECT_DISABLED);
        }
    }

    public Scheduler getObject() {
        if (RunLevel.current().aspectEnabled(SCHEDULED_TASKS)) {
            return super.getObject();
        }
        log.debug(ASPECT_DISABLED);
        return new DummyScheduler();
    }

    public boolean isAutoStartup() {
        if (RunLevel.current().aspectEnabled(SCHEDULED_TASKS)) {
            return super.isAutoStartup();
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (RunLevel.current().aspectEnabled(SCHEDULED_TASKS)) {
            super.afterPropertiesSet();
        } else {
            log.warn(ASPECT_DISABLED);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        super.setApplicationContext(applicationContext);
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        TaskManager manager = (TaskManager)applicationContext.getBean("taskManager");
        Collection<Task> tasks = manager.getTasks(applicationContext);
        for (Task task : tasks) {
            Object object;
            String name = task.getName();
            String triggerName = name + "Trigger";
            if (!applicationContext.containsBean(triggerName)) {
                triggerName = Character.toLowerCase(triggerName.charAt(0)) + triggerName.substring(1);
            }
            if ((object = applicationContext.getBean(triggerName)) instanceof Trigger) {
                Trigger trgr = (Trigger)object;
                triggers.add(trgr);
                continue;
            }
            log.warn("Cannot schedule task {}", (Object)name);
        }
        try {
            triggers.add((Trigger)applicationContext.getBean("TempFolderCleaner"));
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        if (!triggers.isEmpty()) {
            this.setTriggers(triggers.toArray(new Trigger[0]));
        }
    }
}

