/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.task;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.task.DocumentProcessorCallable;
import com.logicaldoc.core.task.DocumentProcessorStats;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskException;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.CollectionUtil;
import com.logicaldoc.util.concurrent.LaxSerialFuture;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDocumentProcessor
extends Task {
    private List<DocumentProcessorCallable<? extends DocumentProcessorStats>> threads = new ArrayList<DocumentProcessorCallable<? extends DocumentProcessorStats>>();
    protected int processed = 0;
    protected int errors = 0;
    @Resource(name="documentDAO")
    protected DocumentDAO documentDao;

    protected AbstractDocumentProcessor(String name) {
        super(name);
    }

    @Override
    public void runTask() throws TaskException {
        this.log.info("Start processing of all documents");
        this.errors = 0;
        this.processed = 0;
        this.threads.clear();
        try {
            try {
                int max = this.getBatchSize();
                String currentTransactionIds = this.lockManager.getAllTransactions().stream().map(t -> "'" + t + "'").collect(Collectors.joining(","));
                StringBuilder where = new StringBuilder("_entity");
                where.append(".deleted = 0 and (");
                where.append("_entity");
                where.append(".transactionId is null or ");
                where.append("_entity");
                where.append(".transactionId not in (");
                where.append(StringUtils.defaultString((String)currentTransactionIds, (String)"'unexisting'"));
                where.append(")) and ");
                StringBuilder sort = new StringBuilder();
                this.prepareQueueQuery(where, sort);
                List<Long> ids = this.documentDao.findIdsByWhere(where.toString(), sort.toString(), max);
                this.getSize(max, ids);
                if (this.size > 0L) {
                    this.processDocuments(ids);
                }
            }
            catch (PersistenceException e) {
                throw new TaskException(e.getMessage(), e);
            }
        }
        finally {
            this.log.info("Processing completed");
            this.log.info("Processed documents: {}", (Object)this.processed);
            this.log.info("Errors: {}", (Object)this.errors);
            this.removeTransactionReference();
        }
    }

    protected void processDocuments(List<Long> docIds) throws PersistenceException {
        List<Object[]> records;
        String idsStr = "(" + docIds.stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")) + ")";
        int count = this.documentDao.jdbcUpdate("update ld_document set ld_transactionid='" + this.transactionId + "' where ld_id in " + idsStr);
        if (this.log.isInfoEnabled()) {
            this.log.info("{} documents assigned to transaction {}", (Object)count, (Object)this.transactionId);
        }
        if (!(records = this.documentDao.findByQuery("select A.id, A.fileName from Document A where A.id in " + idsStr, null, null)).isEmpty()) {
            int threadsTotal = this.config.getInt("threadpool." + this.getName() + ".max", 1);
            this.log.info("Distribute the processing among {} threads", (Object)threadsTotal);
            Collection<List<Long>> segments = CollectionUtil.partition(docIds, (int)Math.ceil((double)docIds.size() / (double)threadsTotal));
            ArrayList<Future<? extends DocumentProcessorStats>> futures = new ArrayList<Future<? extends DocumentProcessorStats>>();
            for (List<Long> segment : segments) {
                if (this.interruptRequested) continue;
                DocumentProcessorCallable<? extends DocumentProcessorStats> callable = this.prepareCallable(segment);
                this.threads.add(callable);
                futures.add(Context.get(ThreadPools.class).schedule(callable, this.getName(), 1L));
                this.log.debug("Launched the processing for documents {}", (Object)segment);
            }
            this.waitForCompletion(futures);
            this.log.info("All threads have completed");
        }
    }

    protected abstract DocumentProcessorCallable<? extends DocumentProcessorStats> prepareCallable(List<Long> var1);

    @Override
    public synchronized void interrupt() {
        for (DocumentProcessorCallable<? extends DocumentProcessorStats> thread : this.threads) {
            thread.interrupt();
        }
        super.interrupt();
    }

    protected void waitForCompletion(Collection<Future<? extends DocumentProcessorStats>> futures) {
        try {
            List stats = new LaxSerialFuture(futures).getAll();
            for (DocumentProcessorStats stat : stats) {
                this.processed = (int)((long)this.processed + stat.getProcessed());
                this.errors = (int)((long)this.errors + stat.getErrors());
            }
            this.allCompleted(stats);
        }
        catch (ExecutionException e) {
            this.log.error(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void allCompleted(List<DocumentProcessorStats> stats) {
    }

    private void removeTransactionReference() {
        try {
            int count = this.documentDao.jdbcUpdate("update ld_document set ld_transactionid = null where ld_transactionId = :transactionId", Map.of("transactionId", this.transactionId));
            if (this.log.isInfoEnabled()) {
                this.log.info("{} documents released from transaction {}", (Object)count, (Object)this.transactionId);
            }
        }
        catch (PersistenceException e) {
            this.log.warn(e.getMessage(), e);
        }
    }

    private void getSize(int max, List<Long> ids) {
        this.size = ids.size();
        if ((long)max < this.size && max > 0) {
            this.size = max;
        }
        this.log.info("Found a total of {} documents to be processed", (Object)this.size);
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    protected String getDefaultUser() {
        return "_system";
    }

    protected abstract int getBatchSize();

    protected abstract void prepareQueueQuery(StringBuilder var1, StringBuilder var2);

    @Override
    public String prepareReport(Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(I18N.message("processeddocs", locale) + ": ");
        sb.append(this.processed);
        sb.append("\n");
        sb.append(I18N.message("errors", locale) + ": ");
        sb.append(this.errors);
        return sb.toString();
    }
}

