/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.system;

import com.logicaldoc.core.system.SystemLoadListener;
import com.logicaldoc.util.config.ContextProperties;
import com.sun.management.OperatingSystemMXBean;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="systemLoadMonitor")
public class SystemLoadMonitor {
    private static final Logger log = LoggerFactory.getLogger(SystemLoadMonitor.class);
    @Resource(name="ContextProperties")
    protected ContextProperties config;
    private CircularFifoQueue<Integer> samples = null;
    private int averageCpuLoad = 0;
    private LoadTracker tracker = new LoadTracker();
    private List<SystemLoadListener> listeners = new ArrayList<SystemLoadListener>();
    private boolean lastCheckOverloaded = false;

    public void addListener(SystemLoadListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SystemLoadListener listener) {
        this.listeners.remove(listener);
    }

    private void initSamples() {
        int wantedSamples = this.config.getInt("load.cpusamples", 60);
        if (this.samples == null || this.samples.maxSize() != wantedSamples) {
            CircularFifoQueue newSamples = new CircularFifoQueue(wantedSamples);
            int i = 0;
            while (i < wantedSamples) {
                newSamples.add((Object)0);
                ++i;
            }
            if (this.samples != null) {
                newSamples.addAll(this.samples);
            }
            this.samples = newSamples;
        }
    }

    public int getCpuLoad() {
        try {
            MBeanServer mbsc = ManagementFactory.getPlatformMBeanServer();
            OperatingSystemMXBean osMBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            int loadPErcentage = (int)Math.ceil(osMBean.getCpuLoad() * 100.0);
            if (log.isTraceEnabled()) {
                log.trace("Got CPU load {}%", (Object)loadPErcentage);
            }
            return loadPErcentage;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public boolean isAverageCpuOverLoaded() {
        int cpumax = this.config.getInt("load.cpumax", 50);
        if (cpumax < 1) {
            return false;
        }
        return this.averageCpuLoad > cpumax;
    }

    @PostConstruct
    public void start() {
        this.initSamples();
        this.tracker.setPriority(1);
        this.tracker.start();
        log.info("System load monitor started");
    }

    @PreDestroy
    public void stop() {
        if (this.tracker != null) {
            try {
                this.tracker.end();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class LoadTracker
    extends Thread {
        private boolean running = true;

        LoadTracker() {
        }

        public boolean isRunning() {
            return this.running;
        }

        public void end() {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running) {
                SystemLoadMonitor.this.initSamples();
                int i = 0;
                while (i < SystemLoadMonitor.this.samples.maxSize() && this.running) {
                    this.waitMilliseconds(1000L);
                    this.pickCpuLoad();
                    this.checkOverloadOrUnderload();
                    ++i;
                }
            }
        }

        private void checkOverloadOrUnderload() {
            if (SystemLoadMonitor.this.isAverageCpuOverLoaded()) {
                if (!SystemLoadMonitor.this.lastCheckOverloaded) {
                    log.warn("The system is overloaded ({}%)", (Object)SystemLoadMonitor.this.averageCpuLoad);
                }
                SystemLoadMonitor.this.lastCheckOverloaded = true;
                for (SystemLoadListener listener : SystemLoadMonitor.this.listeners) {
                    listener.onOverload(SystemLoadMonitor.this.averageCpuLoad, SystemLoadMonitor.this.averageCpuLoad);
                }
            } else {
                if (SystemLoadMonitor.this.lastCheckOverloaded) {
                    log.warn("The system is underloaded ({}%)", (Object)SystemLoadMonitor.this.averageCpuLoad);
                }
                SystemLoadMonitor.this.lastCheckOverloaded = false;
                for (SystemLoadListener listener : SystemLoadMonitor.this.listeners) {
                    listener.onUnderload(SystemLoadMonitor.this.averageCpuLoad, SystemLoadMonitor.this.averageCpuLoad);
                }
            }
        }

        private void waitMilliseconds(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                this.end();
                Thread.currentThread().interrupt();
            }
        }

        private void pickCpuLoad() {
            int sample = SystemLoadMonitor.this.getCpuLoad();
            SystemLoadMonitor.this.samples.add((Object)sample);
            SystemLoadMonitor.this.averageCpuLoad = (int)Math.round(SystemLoadMonitor.this.samples.stream().mapToDouble(Double::valueOf).average().getAsDouble());
            if (log.isTraceEnabled()) {
                log.trace("Average CPU load: {}", (Object)SystemLoadMonitor.this.averageCpuLoad);
            }
        }
    }
}

