/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.store;

import com.logicaldoc.core.store.FSStore;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class MockStore
extends FSStore {
    private File dummyFile = new File("pom.xml");
    private boolean errorOnStore = false;
    private boolean useDummyFile = false;

    public boolean isRaiseError() {
        return this.errorOnStore;
    }

    public void setErrorOnStore(boolean errorOnStore) {
        this.errorOnStore = errorOnStore;
    }

    @Override
    public void store(File file, long docId, String resource) throws IOException {
        if (this.errorOnStore) {
            throw new IOException("error");
        }
        if (this.useDummyFile) {
            super.store(this.dummyFile, docId, resource);
        } else {
            super.store(file, docId, resource);
        }
    }

    @Override
    public void store(InputStream stream, long docId, String resource) throws IOException {
        if (this.errorOnStore) {
            stream.close();
            throw new IOException("error");
        }
        if (this.useDummyFile) {
            stream.close();
            super.store(new FileInputStream(this.dummyFile), docId, resource);
        } else {
            super.store(stream, docId, resource);
        }
    }

    @Override
    public InputStream getStream(long docId, String resource) throws IOException {
        if (this.useDummyFile) {
            return new FileInputStream(this.dummyFile);
        }
        return super.getStream(docId, resource);
    }

    public boolean isUseDummyFile() {
        return this.useDummyFile;
    }

    public void setUseDummyFile(boolean useDummyFile) {
        this.useDummyFile = useDummyFile;
    }

    @Override
    public int moveResourcesToStore(long docId, int targetStoreId) throws IOException {
        String targetRoot = Context.get().getProperties().getProperty("store." + targetStoreId + ".dir");
        int moved = 0;
        List<String> resources = this.listResources(docId, null);
        for (String resource : resources) {
            File sourceFile = new File(this.getContainer(docId), resource);
            File targetFile = new File(targetRoot);
            targetFile = new File(targetFile, this.computeRelativePath(docId));
            targetFile = new File(targetFile, resource);
            targetFile.getParentFile().mkdirs();
            this.writeToFile(docId, resource, targetFile);
            ++moved;
            FileUtil.delete(sourceFile);
        }
        return moved;
    }

    public File getDummyFile() {
        return this.dummyFile;
    }

    public void setDummyFile(File dummyFile) {
        this.dummyFile = dummyFile;
    }
}

