/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.store;

import com.logicaldoc.core.store.AbstractStore;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSStore
extends AbstractStore {
    private static final Logger log = LoggerFactory.getLogger(FSStore.class);

    @Override
    public void delete(long docId) {
        File docDir = this.getContainer(docId);
        if (docDir == null || !docDir.exists()) {
            return;
        }
        File[] fileArray = docDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            log.info("Deleting stored file {}", (Object)file.getAbsolutePath());
            if (FileUtil.delete(file)) {
                this.logDeletion(docId, file.getAbsolutePath());
            }
            ++n2;
        }
        log.info("Deleting stored folder {}", (Object)docDir.getAbsolutePath());
        FileUtil.delete(docDir);
        this.logDeletion(docId, docDir.getAbsolutePath());
    }

    @Override
    public void delete(long docId, String resource) {
        File file = new File(this.getContainer(docId), resource);
        log.info("Deleting stored file {}", (Object)file.getAbsolutePath());
        if (FileUtil.delete(file)) {
            this.logDeletion(docId, file.getAbsolutePath());
        }
    }

    public File getContainer(long docId) {
        String relativePath = this.computeRelativePath(docId);
        String path = this.getRoot().getPath() + "/" + relativePath;
        return new File(path);
    }

    public File getRoot() {
        return new File(this.getDir());
    }

    @Override
    public void store(File file, long docId, String resource) throws IOException {
        this.checkEnabled();
        this.checkNotEmpty(file);
        File dir = this.getContainer(docId);
        FileUtils.forceMkdir(dir);
        File dest = new File(dir.getPath() + "/" + this.sanitizeResourceName(resource));
        FileUtil.copyFile(file, dest);
        this.checkWriteAfterStore(docId, resource, file.length());
    }

    @Override
    public void store(InputStream stream, long docId, String resource) throws IOException {
        File file = null;
        try {
            try {
                if (!this.isEnabled()) {
                    throw new IOException("Store not enabled");
                }
                File dir = this.getContainer(docId);
                FileUtils.forceMkdir(dir);
                file = new File(dir.getPath() + "/" + this.sanitizeResourceName(resource));
                FileUtil.writeFile(stream, file.getPath());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            IOUtil.close(stream);
        }
    }

    @Override
    public void writeToFile(long docId, String resource, File out) throws IOException {
        File container = this.getContainer(docId);
        File file = new File(container, this.sanitizeResourceName(resource));
        FileUtil.copyFile(file, out);
    }

    @Override
    public InputStream getStream(long docId, String resource) throws IOException {
        File container = this.getContainer(docId);
        File file = new File(container, this.sanitizeResourceName(resource));
        try {
            return new BufferedInputStream(new FileInputStream(file), 1024);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public long getTotalSize() {
        long size = 0L;
        File docDir = this.getRoot();
        if (docDir.exists()) {
            size = FileUtils.sizeOfDirectory(docDir);
        }
        return size;
    }

    @Override
    public byte[] getBytes(long docId, String resource, long start, long length) throws IOException {
        File container = this.getContainer(docId);
        File file = new File(container, this.sanitizeResourceName(resource));
        return FileUtil.toByteArray(file, start, length);
    }

    @Override
    public List<String> listResources(long docId, String fileVersion) {
        ArrayList<String> resources = new ArrayList<String>();
        File container = this.getContainer(docId);
        File[] buf = container.listFiles((dir, name) -> {
            if (name.startsWith(".")) {
                return false;
            }
            if (StringUtils.isNotEmpty(fileVersion)) {
                return name.startsWith(fileVersion);
            }
            return true;
        });
        if (buf != null) {
            File[] fileArray = buf;
            int n = buf.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                resources.add(file.getName());
                ++n2;
            }
        }
        return resources;
    }

    @Override
    public long size(long docId, String resource) {
        File file = this.getContainer(docId);
        file = new File(file, this.sanitizeResourceName(resource));
        return file.length();
    }

    @Override
    public boolean exists(long docId, String resource) {
        File file = this.getContainer(docId);
        file = new File(file, this.sanitizeResourceName(resource));
        return file.exists();
    }

    @Override
    public List<String> getParameterNames() {
        return new ArrayList<String>();
    }

    @Override
    public int moveResourcesToStore(long docId, int targetStoreId) throws IOException {
        throw new UnsupportedOperationException();
    }
}

