/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.store;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStore
implements Store {
    private static final String STORE = "store.";
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final Logger log = LoggerFactory.getLogger(AbstractStore.class);
    protected static Logger deletionsLog = LoggerFactory.getLogger("STORE_DELETIONS");
    @Resource(name="ContextProperties")
    protected ContextProperties config;
    protected int id = 1;
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected Map<String, Store> storeDefinitions = new HashMap<String, Store>();

    protected AbstractStore() {
    }

    public ContextProperties getConfig() {
        if (this.config == null) {
            this.config = Context.get().getProperties();
        }
        return this.config;
    }

    public void setConfig(ContextProperties config) {
        this.config = config;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int compareTo(Store o) {
        return Integer.compare(this.id, o.getId());
    }

    public int hashCode() {
        return Integer.valueOf(this.id).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id == ((Store)obj).getId();
    }

    @Override
    public void store(File file, long docId, String resource) throws IOException {
        this.checkEnabled();
        Throwable throwable = null;
        Object var6_6 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 1024);){
            this.store(is, docId, resource);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.checkWriteAfterStore(docId, resource, file.length());
    }

    protected void checkNotEmpty(File file) throws IOException {
        if (file == null) {
            throw new IOException("Do not store null file");
        }
        if (file.length() == 0L) {
            throw new IOException("Do not store 0 byte file");
        }
    }

    protected void checkWriteAfterStore(long docId, String resource, long expectedSize) throws IOException {
        long storedSize;
        if (RunLevel.current().aspectEnabled("writeCheck") && docId != 0L && (storedSize = this.size(docId, resource)) != expectedSize) {
            throw new IOException(String.format("Wrong file size, the original file was %d bytes while the stored one is %d bytes (docId: %d,  resource: %s", expectedSize, storedSize, docId, resource));
        }
    }

    protected void checkEnabled() throws IOException {
        if (!this.isEnabled()) {
            throw new IOException("Store not enabled");
        }
    }

    protected String computeRelativePath(long docId) {
        return StringUtil.split(Long.toString(docId), '/', 3) + "/doc";
    }

    protected String computeRelativePath(long docId, String resource) {
        StringBuilder tmp = new StringBuilder(this.computeRelativePath(docId));
        if (StringUtils.isNotEmpty(resource)) {
            if (!tmp.toString().endsWith("/")) {
                tmp.append("/");
            }
            tmp.append(resource.startsWith("/") ? resource.substring(1) : resource);
        } else if (!tmp.toString().endsWith("/")) {
            tmp.append("/");
        }
        return tmp.toString();
    }

    @Override
    public byte[] getBytes(long docId, String resource) throws IOException {
        Throwable throwable = null;
        Object var5_5 = null;
        try (InputStream is = this.getStream(docId, resource);){
            return IOUtils.toByteArray(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void writeToStream(long docId, String resource, OutputStream output, long start, long length) throws IOException {
        Throwable throwable = null;
        Object var10_8 = null;
        try (InputStream input = this.getStream(docId, resource);){
            IOUtils.copyLarge(input, output, start, length);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void writeToStream(long docId, String resource, OutputStream output) throws IOException {
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream input = this.getStream(docId, resource);){
            IOUtils.copyLarge(input, output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeToFile(long docId, String resource, File out) throws IOException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out, false), 1024);
                try {
                    try (InputStream is = this.getStream(docId, resource);){
                        FileUtil.writeFile(is, out.getPath());
                    }
                    if (os == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (os == null) throw throwable;
                    ((OutputStream)os).close();
                    throw throwable;
                }
                ((OutputStream)os).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            log.error("Error writing document {} into {}", (Object)docId, (Object)out.getPath());
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public String getString(long docId, String resource) {
        StringWriter writer = new StringWriter();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream input = this.getStream(docId, resource);){
                IOUtils.copy(input, (Writer)writer, StandardCharsets.UTF_8);
                return writer.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    protected String getDir() {
        return this.getConfig().getProperty(STORE + this.id + ".dir");
    }

    @Override
    public String getResourceName(Document doc, String fileVersion, String suffix) {
        Object resourceName;
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document document = doc;
        if (doc.getDocRef() != null) {
            try {
                document = (Document)docDao.findById(doc.getDocRef());
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
        if (StringUtils.isEmpty((String)(resourceName = StringUtils.isEmpty(fileVersion) ? document.getFileVersion() : fileVersion))) {
            resourceName = document.getVersion();
        }
        if (StringUtils.isNotEmpty(suffix)) {
            resourceName = (String)resourceName + "-" + suffix;
        }
        return this.sanitizeResourceName((String)resourceName);
    }

    @Override
    public String getResourceName(long docId, String fileVersion, String suffix) {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            Document doc = (Document)docDao.findById(docId);
            return this.getResourceName(doc, fileVersion, suffix);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    protected String sanitizeResourceName(String resourceName) {
        return resourceName.replace("..", "").replaceAll("[^a-zA-Z0-9\\-\\\\.]", "");
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean test() {
        String resource = "test";
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile("st-test", ".txt");
            FileUtil.writeFile("test", tmpFile.getAbsolutePath());
            this.store(tmpFile, 0L, resource);
            boolean bl = this.exists(0L, resource);
            return bl;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return false;
        }
        finally {
            FileUtil.delete(tmpFile);
            try {
                if (this.exists(0L, resource)) {
                    this.delete(0L, resource);
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " #" + this.id;
    }

    @Override
    @PostConstruct
    public void init() {
        if (!this.storeDefinitions.isEmpty()) {
            return;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "Store");
        for (Extension ext : exts) {
            String type = ext.getParameter("type").valueAsString();
            String className = ext.getParameter("class").valueAsString();
            try {
                Class<?> clazz = Class.forName(className);
                Object store = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(store instanceof Store)) {
                    throw new ClassNotFoundException(String.format("The specified store %s doesn't implement the Store interface", className));
                }
                this.storeDefinitions.put(type, (Store)store);
                Store st = (Store)store;
                for (String name : st.getParameterNames()) {
                    st.getParameters().put(name, null);
                }
                log.info("Added new store {} for type {}", (Object)clazz.getSimpleName(), (Object)type);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    @Override
    @PreDestroy
    public void destroy() {
    }

    protected void logDeletion(long docId, String path) {
        if (deletionsLog.isInfoEnabled()) {
            deletionsLog.info("str: {}, doc: {}, res: {}\n{}", this.getId(), docId, path, Arrays.toString(Thread.currentThread().getStackTrace()).replace(',', '\n'));
        }
        DocumentHistoryDAO documentHistoryDAO = Context.get(DocumentHistoryDAO.class);
        DocumentHistory history = new DocumentHistory();
        history.setEvent(DocumentEvent.RESOURCE_DELETED);
        history.setDocId(docId);
        history.setComment(path);
        history.setFilename(StringUtils.right(path, 255));
        history.setReason("deleted from store " + this.getId());
        try {
            documentHistoryDAO.queryForResultSet("select ld_tenantid, ld_filename, ld_version, ld_fileversion, ld_color, ld_folderid from ld_document where ld_id=" + docId, null, null, rows -> {
                if (rows.next()) {
                    history.setTenantId(rows.getLong(1));
                    history.setFilename(rows.getString(2));
                    history.setVersion(rows.getString(3));
                    history.setFileVersion(rows.getString(4));
                    history.setColor(rows.getString(5));
                    history.setFolderId(rows.getLong(6));
                }
            });
            documentHistoryDAO.store(history);
        }
        catch (PersistenceException e) {
            log.warn("Cannot record in the database the deleteion of resource {} for document {}", path, docId, e);
        }
    }

    @Override
    public Store newStore(int id) {
        String type = this.config.getProperty(STORE + id + ".type", "fs");
        Store definition = this.storeDefinitions.get(type);
        if (definition == null) {
            log.error("Unexisting definition for {}", (Object)type);
            return null;
        }
        Store store = null;
        try {
            store = (Store)definition.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("Unable to instanciate class {} / {}", (Object)definition.getClass(), (Object)e.getMessage());
            log.error(e.getMessage(), e);
            return null;
        }
        store.setId(id);
        Set<String> params = definition.getParameters().keySet();
        for (String param : params) {
            store.getParameters().put(param, this.config.getProperty(STORE + id + "." + param, ""));
        }
        return store;
    }

    @Override
    public Map<String, Store> getStoreDefinitions() {
        return this.storeDefinitions;
    }
}

