/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.stats;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskException;
import com.logicaldoc.core.util.UserUtil;
import com.logicaldoc.util.http.HttpUtil;
import com.logicaldoc.util.http.StringHttpClientResponseHandler;
import com.logicaldoc.util.plugin.PluginRegistry;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.LoggerFactory;

public class StatsCollector
extends Task {
    private static final String AND_NOT_A_LD_STATUS = " and not A.ld_status=";
    private static final String AND_A_LD_TENANTID = " and A.ld_tenantid=";
    public static final String STAT = "stat";
    public static final String NAME = "StatsCollector";
    @Resource(name="documentDAO")
    private DocumentDAO documentDAO;
    @Resource(name="folderDAO")
    private FolderDAO folderDAO;
    @Resource(name="groupDAO")
    private GroupDAO groupDAO;
    @Resource(name="genericDAO")
    protected GenericDAO genericDAO;
    @Resource(name="tenantDAO")
    protected TenantDAO tenantDAO;
    @Resource(name="sequenceDAO")
    private SequenceDAO sequenceDAO;
    private static String userno = "community";
    private static String sid;
    private static String product;
    private static String productName;
    private boolean uploadStatistics = true;
    private List<NameValuePair> statistics = new ArrayList<NameValuePair>();

    static {
        product = "LogicalDOC";
        productName = "LogicalDOC Community";
    }

    public StatsCollector() {
        super(NAME);
        this.log = LoggerFactory.getLogger(StatsCollector.class);
    }

    @Override
    public long getSize() {
        return 9L;
    }

    @Override
    protected void runTask() throws TaskException {
        this.log.info("Start statistics collection");
        String id = this.config.getProperty("id");
        String release = this.config.getProperty("product.release");
        this.log.debug("Collected identification data");
        EMailSender sender = new EMailSender("default");
        String email = sender.getSender();
        this.log.debug("Collected contact data");
        String osname = System.getProperty("os.name");
        String osversion = System.getProperty("os.version");
        String javaversion = System.getProperty("java.version");
        String javavendor = System.getProperty("java.vendor");
        String fileencoding = System.getProperty("file.encoding");
        String userlanguage = System.getProperty("user.language");
        String usercountry = System.getProperty("user.country");
        String javaarch = System.getProperty("sun.arch.data.model");
        String dbms = this.config.getProperty("jdbc.dbms");
        this.log.debug("Collected environment data");
        String regName = this.config.getProperty("reg.name");
        String regEmail = this.config.getProperty("reg.email");
        String regOrganization = this.config.getProperty("reg.organization");
        String regWebsite = this.config.getProperty("reg.website");
        this.next();
        if (this.interruptRequested) {
            return;
        }
        try {
            int users = this.userDao.count(null);
            int guests = this.userDao.countGuests(null);
            int groups = this.groupDAO.count();
            this.log.debug("Collected users data");
            long userdir = this.calculateUserDirSize();
            this.saveStatistic("userdir", userdir, -1L);
            long indexdir = this.calculateIndexDirSize();
            this.saveStatistic("indexdir", indexdir, -1L);
            long importdir = this.calculateImportDirSize();
            this.saveStatistic("importdir", importdir, -1L);
            long exportdir = this.calculateExportDirSize();
            this.saveStatistic("exportdir", exportdir, -1L);
            long plugindir = this.calculatePluginDirSize();
            this.saveStatistic("plugindir", plugindir, -1L);
            this.next();
            if (this.interruptRequested) {
                return;
            }
            long dbdir = this.calculateDatabaseSize();
            this.saveStatistic("dbdir", dbdir, -1L);
            long logdir = this.calculateLogDirSize();
            this.saveStatistic("logdir", logdir, -1L);
            this.log.info("Saved repository statistics");
            this.next();
            if (this.interruptRequested) {
                return;
            }
            long[] docStats = this.extractDocStats(-1L);
            long totaldocs = docStats[3];
            long archiveddocs = docStats[4];
            long docdir = docStats[5];
            long trash = docStats[7];
            this.calculateAllTenantsDocsStats();
            this.log.info("Saved documents statistics");
            this.next();
            if (this.interruptRequested) {
                return;
            }
            long[] pageStats = this.extractPageStats(-1L);
            long totalpages = pageStats[3];
            this.calculateAllTenantsPageStats();
            this.log.info("Saved pages statistics");
            this.next();
            if (this.interruptRequested) {
                return;
            }
            long[] fldStats = this.extractFldStats(-1L);
            long withdocs = fldStats[0];
            long empty = fldStats[1];
            long deletedfolders = fldStats[2];
            this.calculateAllTenantsFolderStats();
            this.log.info("Saved folder statistics");
            this.next();
            if (this.interruptRequested) {
                return;
            }
            long tags = this.folderDAO.queryForLong("SELECT COUNT(*) FROM ld_tag");
            long versions = this.folderDAO.queryForLong("SELECT COUNT(*) FROM ld_version");
            long histories = this.folderDAO.queryForLong("SELECT COUNT(*) FROM ld_history");
            long userHistories = this.folderDAO.queryForLong("SELECT COUNT(*) FROM ld_user_history");
            long votes = this.folderDAO.queryForLong("SELECT COUNT(*) FROM ld_rating");
            long wsCalls = this.sequenceDAO.getCurrentValue("wscall", 0L, -1L);
            this.saveStatistic("lastrun", new Date(), -1L);
            this.log.info("Statistics collected");
            this.next();
            if (this.interruptRequested) {
                return;
            }
            this.log.debug("Package collected statistics");
            this.statistics.clear();
            this.statistics.add((NameValuePair)new BasicNameValuePair("id", StringUtils.defaultString(id)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("userno", StringUtils.defaultString(userno)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("sid", StringUtils.defaultString(sid)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("product_release", StringUtils.defaultString(release)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("email", StringUtils.defaultString(email)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("product", StringUtils.defaultString(product)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("product_name", StringUtils.defaultString(productName)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("java_version", StringUtils.defaultString(javaversion)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("java_vendor", StringUtils.defaultString(javavendor)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("java_arch", StringUtils.defaultString(javaarch)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("dbms", StringUtils.defaultString(dbms)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("os_name", StringUtils.defaultString(osname)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("os_version", StringUtils.defaultString(osversion)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("file_encoding", StringUtils.defaultString(fileencoding)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("user_language", StringUtils.defaultString(userlanguage)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("user_country", StringUtils.defaultString(usercountry)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("users", Integer.toString(users)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("guests", Integer.toString(guests)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("groups", Integer.toString(groups)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("docs", Long.toString(totaldocs)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("pages", Long.toString(totalpages)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("archived_docs", Long.toString(archiveddocs)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("folders", Long.toString(withdocs + empty + deletedfolders)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("tags", Long.toString(tags)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("versions", Long.toString(versions)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("histories", Long.toString(histories)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("user_histories", Long.toString(userHistories)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("votes", Long.toString(votes)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("wscalls", Long.toString(wsCalls)));
            this.collectFeatureUsageStats(this.statistics);
            this.next();
            if (this.interruptRequested) {
                return;
            }
            Date lastLogin = this.findLastLogin();
            this.statistics.add((NameValuePair)new BasicNameValuePair("last_login", this.formatDate(lastLogin)));
            Date lastCreation = this.findLastCreation();
            this.statistics.add((NameValuePair)new BasicNameValuePair("last_creation", this.formatDate(lastCreation)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("docdir", Long.toString(docdir)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("trash", Long.toString(trash)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("indexdir", Long.toString(indexdir)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("quota", Long.toString(docdir + indexdir + userdir + importdir + exportdir + plugindir + dbdir + logdir)));
            this.statistics.add((NameValuePair)new BasicNameValuePair("reg_name", regName != null ? regName : ""));
            this.statistics.add((NameValuePair)new BasicNameValuePair("reg_email", regEmail != null ? regEmail : ""));
            this.statistics.add((NameValuePair)new BasicNameValuePair("reg_organization", regOrganization != null ? regOrganization : ""));
            this.statistics.add((NameValuePair)new BasicNameValuePair("reg_website", regWebsite != null ? regWebsite : ""));
            this.uploadStatistics(this.statistics);
            this.next();
        }
        catch (PersistenceException e) {
            throw new TaskException(e.getMessage(), e);
        }
    }

    private String formatDate(Date lastLogin) {
        SimpleDateFormat isoDf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return lastLogin != null ? isoDf.format(lastLogin) : "";
    }

    private void uploadStatistics(List<NameValuePair> postParams) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(60);){
                HttpPost post = new HttpPost("http://stat.logicaldoc.com/stats/collect");
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(postParams, StandardCharsets.UTF_8);
                post.setEntity((HttpEntity)entity);
                if (this.uploadStatistics) {
                    httpClient.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new StringHttpClientResponseHandler());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.log.info("Statistics packaged");
        }
        catch (IOException e) {
            this.log.warn("Troubles sending the statistics");
            this.log.debug("Unable to send statistics", e);
        }
    }

    private Date findLastLogin() {
        Date lastLogin = null;
        try {
            lastLogin = this.documentDAO.queryForObject("select max(ld_date) from ld_user_history where ld_deleted=0 and ld_event='" + UserEvent.LOGIN.toString() + "'", Date.class);
        }
        catch (Exception t) {
            this.log.warn("Unable to retrieve last login statistics - {}", (Object)t.getMessage());
        }
        return lastLogin;
    }

    private Date findLastCreation() {
        Date lastCreation = null;
        try {
            lastCreation = this.documentDAO.queryForObject("select max(ld_date) from ld_history where ld_deleted=0 and ld_event='" + String.valueOf((Object)DocumentEvent.STORED) + "'", Date.class);
        }
        catch (Exception t) {
            this.log.warn("Unable to retrieve last creation statistics - {}", (Object)t.getMessage());
        }
        return lastCreation;
    }

    private void calculateAllTenantsFolderStats() throws PersistenceException {
        for (Tenant tenant : this.tenantDAO.findAll()) {
            this.extractFldStats(tenant.getId());
        }
    }

    private void calculateAllTenantsPageStats() throws PersistenceException {
        for (Tenant tenant : this.tenantDAO.findAll()) {
            this.extractPageStats(tenant.getId());
        }
    }

    private void calculateAllTenantsDocsStats() throws PersistenceException {
        for (Tenant tenant : this.tenantDAO.findAll()) {
            this.extractDocStats(tenant.getId());
        }
    }

    private long calculateLogDirSize() {
        long logdir = 0L;
        File logsDir = new File(this.config.getProperty("conf.logdir"));
        if (logsDir.exists()) {
            logdir = FileUtils.sizeOfDirectory(logsDir);
        }
        return logdir;
    }

    private long calculatePluginDirSize() {
        long plugindir = 0L;
        File pluginsDir = PluginRegistry.getPluginsDir();
        plugindir = FileUtils.sizeOfDirectory(pluginsDir);
        return plugindir;
    }

    private long calculateExportDirSize() {
        long exportdir = 0L;
        File exportDir = new File(this.config.getProperty("conf.exportdir"));
        if (exportDir.exists()) {
            exportdir = FileUtils.sizeOfDirectory(exportDir);
        }
        return exportdir;
    }

    private long calculateImportDirSize() {
        long importdir = 0L;
        File importDir = new File(this.config.getProperty("conf.importdir"));
        if (importDir.exists()) {
            importdir = FileUtils.sizeOfDirectory(importDir);
        }
        return importdir;
    }

    private long calculateIndexDirSize() {
        long indexdir = 0L;
        File indexDir = new File(this.config.getProperty("index.dir"));
        if (indexDir.exists()) {
            indexdir = FileUtils.sizeOfDirectory(indexDir);
        }
        return indexdir;
    }

    private long calculateUserDirSize() {
        long userdir = 0L;
        File userDir = UserUtil.getUsersDir();
        userdir = FileUtils.sizeOfDirectory(userDir);
        return userdir;
    }

    private long calculateDatabaseSize() {
        File dbDir;
        long dbdir = 0L;
        try {
            if ("mysql".equals(this.documentDAO.getDbms())) {
                dbdir = this.documentDAO.queryForLong("select sum(data_length+index_length) from information_schema.tables where table_schema=database();");
            } else if (this.documentDAO.isOracle()) {
                dbdir = this.documentDAO.queryForLong("SELECT sum(bytes) FROM user_segments");
            } else if ("postgresql".equals(this.documentDAO.getDbms())) {
                dbdir = this.documentDAO.queryForLong("select pg_database_size(current_database())");
            }
        }
        catch (Exception t) {
            this.log.warn("Unable to determine the database size - {}", (Object)t.getMessage());
        }
        if (dbdir == 0L && (dbDir = new File(this.config.getProperty("conf.dbdir"))).exists()) {
            dbdir = FileUtils.sizeOfDirectory(dbDir);
        }
        return dbdir;
    }

    private void collectFeatureUsageStats(List<NameValuePair> postParams) {
        long bookmarks = 0L;
        try {
            bookmarks = this.folderDAO.queryForLong("SELECT COUNT(ld_id) FROM ld_bookmark where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate bookmarks statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("bookmarks", Long.toString(bookmarks)));
        long links = 0L;
        try {
            links = this.folderDAO.queryForLong("SELECT COUNT(ld_id) FROM ld_link where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate links statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("links", Long.toString(links)));
        long notes = 0L;
        try {
            notes = this.folderDAO.queryForLong("SELECT COUNT(ld_id) FROM ld_note where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate notes statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("notes", Long.toString(notes)));
        long aliases = 0L;
        try {
            aliases = this.folderDAO.queryForLong("SELECT COUNT(ld_id) FROM ld_document WHERE ld_docref IS NOT NULL");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate aliases statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("aliases", Long.toString(aliases)));
        long tenants = 0L;
        try {
            tenants = this.folderDAO.queryForLong("SELECT COUNT(ld_id) FROM ld_tenant where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate tenants statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("tenants", Long.toString(tenants)));
        long workflowHistories = 0L;
        try {
            workflowHistories = this.folderDAO.queryForLong("SELECT COUNT(ld_id) FROM ld_workflowhistory where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate workflow statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("workflow_histories", Long.toString(workflowHistories)));
        long templates = 0L;
        try {
            templates = this.documentDAO.queryForLong("select count(ld_id) from ld_template where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate templates statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("templates", Long.toString(templates)));
        long importFolders = 0L;
        try {
            importFolders = this.documentDAO.queryForLong("select count(ld_id) from ld_importfolder where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate import folders statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("importfolders", Long.toString(importFolders)));
        long stamps = 0L;
        try {
            stamps = this.documentDAO.queryForLong("select count(ld_id) from ld_stamp where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate stamps statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("stamps", Long.toString(stamps)));
        long forms = 0L;
        try {
            forms = this.documentDAO.queryForLong("select count(ld_id) from ld_form where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate forms statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("forms", Long.toString(forms)));
        long reports = 0L;
        try {
            reports = this.documentDAO.queryForLong("select count(ld_id) from ld_report where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate reports statistics - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("reports", Long.toString(reports)));
        long emailAccounts = 0L;
        try {
            this.documentDAO.queryForLong("select count(ld_id) from ld_emailaccount where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate import email accounts - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("emailaccounts", Long.toString(emailAccounts)));
        long calendarEvents = 0L;
        try {
            this.documentDAO.queryForLong("select count(ld_id) from ld_event where ld_deleted=0");
        }
        catch (Exception t) {
            this.log.warn("Unable to calculate calendar events - {}", (Object)t.getMessage());
        }
        postParams.add((NameValuePair)new BasicNameValuePair("calendarevents", Long.toString(calendarEvents)));
    }

    private long[] extractDocStats(long tenantId) throws PersistenceException {
        long[] stats = new long[8];
        stats[0] = 0L;
        try {
            stats[0] = this.documentDAO.queryForLong("SELECT COUNT(A.ld_id) FROM ld_document A where A.ld_indexed = 0 and A.ld_deleted = 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : "") + AND_NOT_A_LD_STATUS + DocumentStatus.ARCHIVED.ordinal());
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[1] = 0L;
        try {
            stats[1] = this.documentDAO.queryForLong("SELECT COUNT(A.ld_id) FROM ld_document A where A.ld_indexed = 1 and A.ld_deleted = 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : "") + AND_NOT_A_LD_STATUS + DocumentStatus.ARCHIVED.ordinal());
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[2] = 0L;
        try {
            stats[2] = this.documentDAO.queryForLong("SELECT COUNT(A.ld_id) FROM ld_document A where A.ld_deleted  > 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : ""));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[3] = tenantId != -1L ? this.documentDAO.count(tenantId, true, true) : this.documentDAO.count(null, true, true);
        stats[4] = 0L;
        try {
            stats[4] = this.documentDAO.queryForLong("SELECT COUNT(A.ld_id) FROM ld_document A where A.ld_deleted=0 and A.ld_status = " + DocumentStatus.ARCHIVED.ordinal() + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : ""));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[5] = this.documentDAO.computeTotalSize(tenantId != -1L ? Long.valueOf(tenantId) : null, null, true);
        stats[6] = 0L;
        try {
            stats[6] = this.documentDAO.queryForLong("SELECT COUNT(A.ld_id) FROM ld_document A where A.ld_deleted = 0 and A.ld_indexed = " + IndexingStatus.SKIP.ordinal() + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : "") + AND_NOT_A_LD_STATUS + DocumentStatus.ARCHIVED.ordinal());
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[7] = stats[5] - this.documentDAO.computeTotalSize(tenantId, null, false);
        this.saveStatistic("notindexeddocs", stats[0], tenantId);
        this.saveStatistic("indexeddocs", stats[1], tenantId);
        this.saveStatistic("deleteddocs", stats[2], tenantId);
        this.saveStatistic("totaldocs", stats[3], tenantId);
        this.saveStatistic("archiveddocs", stats[4], tenantId);
        this.saveStatistic("docdir", stats[5], tenantId);
        this.saveStatistic("notindexabledocs", stats[6], tenantId);
        this.saveStatistic("trash", stats[7], tenantId);
        return stats;
    }

    private long[] extractPageStats(long tenantId) throws PersistenceException {
        long[] stats = new long[6];
        stats[0] = 0L;
        try {
            stats[0] = this.documentDAO.queryForLong("SELECT SUM(A.ld_pages) FROM ld_document A where A.ld_pages > 0 and A.ld_indexed = 0 and A.ld_deleted = 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : "") + AND_NOT_A_LD_STATUS + DocumentStatus.ARCHIVED.ordinal());
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[1] = 0L;
        try {
            stats[1] = this.documentDAO.queryForLong("SELECT SUM(A.ld_pages) FROM ld_document A where A.ld_pages > 0 and A.ld_indexed = 1 and A.ld_deleted = 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : "") + AND_NOT_A_LD_STATUS + DocumentStatus.ARCHIVED.ordinal());
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[2] = 0L;
        try {
            stats[2] = this.documentDAO.queryForLong("SELECT SUM(A.ld_pages) FROM ld_document A where A.ld_deleted  > 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : ""));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[3] = 0L;
        try {
            stats[3] = this.documentDAO.queryForLong("SELECT SUM(A.ld_pages) FROM ld_document A where A.ld_pages > 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : ""));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[4] = 0L;
        try {
            stats[4] = this.documentDAO.queryForLong("SELECT SUM(A.ld_pages) FROM ld_document A where A.ld_status = " + DocumentStatus.ARCHIVED.ordinal() + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : ""));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[5] = 0L;
        try {
            stats[5] = this.documentDAO.queryForLong("SELECT SUM(A.ld_pages) FROM ld_document A where A.ld_indexed = " + IndexingStatus.SKIP.ordinal() + " and A.ld_deleted = 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : "") + AND_NOT_A_LD_STATUS + DocumentStatus.ARCHIVED.ordinal());
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        this.saveStatistic("notindexedpages", stats[0], tenantId);
        this.saveStatistic("indexedpages", stats[1], tenantId);
        this.saveStatistic("deletedpages", stats[2], tenantId);
        this.saveStatistic("totalpages", stats[3], tenantId);
        this.saveStatistic("archivedpages", stats[4], tenantId);
        this.saveStatistic("notindexablepages", stats[5], tenantId);
        return stats;
    }

    private long[] extractFldStats(long tenantId) throws PersistenceException {
        long[] stats = new long[4];
        stats[0] = 0L;
        try {
            stats[0] = this.folderDAO.queryForLong("SELECT COUNT(A.ld_id) FROM ld_folder A where A.ld_deleted = 0 and A.ld_id in (select B.ld_folderid FROM ld_document B where B.ld_deleted = 0) " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : ""));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[1] = 0L;
        try {
            stats[1] = this.folderDAO.queryForLong("SELECT COUNT(A.ld_id) FROM ld_folder A where A.ld_deleted = 0 and A.ld_id not in (select B.ld_folderid FROM ld_document B where B.ld_deleted = 0) " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : ""));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        stats[2] = 0L;
        try {
            stats[2] = this.folderDAO.queryForLong("SELECT COUNT(A.ld_id) FROM ld_folder A where A.ld_deleted  > 0 " + (String)(tenantId != -1L ? AND_A_LD_TENANTID + tenantId : ""));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        this.saveStatistic("withdocs", stats[0], tenantId);
        this.saveStatistic("empty", stats[1], tenantId);
        this.saveStatistic("deletedfolders", stats[2], tenantId);
        return stats;
    }

    protected void saveStatistic(String parameter, Object val, long tenantId) throws PersistenceException {
        Generic gen = this.genericDAO.findByAlternateKey(STAT, parameter, null, tenantId);
        if (gen == null) {
            gen = new Generic();
            gen.setType(STAT);
            gen.setTenantId(tenantId);
            gen.setSubtype(parameter);
        } else {
            this.genericDAO.initialize(gen);
        }
        Object object = val;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Date.class, String.class, Integer.class, Long.class}, (Object)object2, n)) {
            case 0: {
                Date dateVal = (Date)object2;
                gen.setDate1(dateVal);
                break;
            }
            case 1: {
                String stringVal = (String)object2;
                gen.setString1(stringVal);
                break;
            }
            case 2: {
                Integer intVal = (Integer)object2;
                gen.setInteger1(intVal.longValue());
                break;
            }
            case 3: {
                Long longVal = (Long)object2;
                gen.setInteger1(longVal);
                break;
            }
            default: {
                gen.setInteger1(null);
            }
        }
        try {
            this.genericDAO.store(gen);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }

    public static void setUserno(String userno) {
        StatsCollector.userno = userno;
    }

    public static void setSID(String sid) {
        StatsCollector.sid = sid;
    }

    public static void setProduct(String product) {
        StatsCollector.product = product;
    }

    public static void setProductName(String productName) {
        StatsCollector.productName = productName;
    }

    void setUploadStatistics(boolean uploadStatistics) {
        this.uploadStatistics = uploadStatistics;
    }

    List<NameValuePair> getStatistics() {
        return this.statistics;
    }
}

