/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.sequence;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.sequence.Sequence;
import com.logicaldoc.core.sequence.SequenceDAO;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="sequenceDAO")
@Transactional
public class HibernateSequenceDAO
extends HibernatePersistentObjectDAO<Sequence>
implements SequenceDAO {
    private static final String TENANTID = "tenantId";
    private static final String AND = " and ";

    private HibernateSequenceDAO() {
        super(Sequence.class);
        this.log = LoggerFactory.getLogger(HibernateSequenceDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reset(String sequence, long objectId, long tenantId, long value) {
        Class<SequenceDAO> clazz = SequenceDAO.class;
        synchronized (SequenceDAO.class) {
            Sequence seq = this.findByAlternateKey(sequence, objectId, tenantId);
            if (seq == null) {
                seq = new Sequence();
            }
            seq.setName(sequence);
            seq.setObjectId(objectId);
            seq.setTenantId(tenantId);
            seq.setLastReset(new Date());
            seq.setValue(value);
            try {
                this.store(seq);
            }
            catch (PersistenceException e) {
                this.log.error(e.getMessage(), e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long next(String sequence, long objectId, long tenantId, long increment) {
        Class<SequenceDAO> clazz = SequenceDAO.class;
        synchronized (SequenceDAO.class) {
            Sequence seq = this.findByAlternateKey(sequence, objectId, tenantId);
            if (seq == null) {
                seq = new Sequence();
            }
            seq.setName(sequence);
            seq.setObjectId(objectId);
            seq.setTenantId(tenantId);
            seq.setValue(seq.getValue() + increment);
            try {
                this.store(seq);
                this.flush();
            }
            catch (PersistenceException e) {
                this.log.error(e.getMessage(), e);
            }
            return seq.getValue();
        }
    }

    @Override
    public synchronized long next(String sequence, long objectId, long tenantId) {
        return this.next(sequence, objectId, tenantId, 1L);
    }

    @Override
    public long getCurrentValue(String sequence, long objectId, long tenantId) {
        Sequence seq = this.findByAlternateKey(sequence, objectId, tenantId);
        if (seq == null) {
            return 0L;
        }
        return seq.getValue();
    }

    @Override
    public List<Sequence> findByName(String name, long tenantId) {
        String query = " _entity.tenantId = :tenantId  and _entity.name like :name ";
        try {
            return this.findByWhere(query, Map.of(TENANTID, tenantId, "name", name + "%"), null, null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Sequence>();
        }
    }

    @Override
    public Sequence findByAlternateKey(String name, long objectId, long tenantId) {
        try {
            List<Sequence> sequences = this.findSequences(name, objectId, tenantId);
            Sequence sequence = null;
            sequence = sequences.isEmpty() ? this.findSequence(name, objectId, tenantId, sequence) : sequences.get(0);
            if (sequence == null) {
                this.log.debug("Unable to find sequence {},{},{}", name, objectId, tenantId);
            } else {
                this.refresh(sequence);
            }
            return sequence;
        }
        catch (Exception t) {
            this.log.error(t.getMessage(), t);
            return null;
        }
    }

    private Sequence findSequence(String sequenceName, long objectId, long tenantId, Sequence sequence) {
        String query = "select ld_id from ld_sequence where ld_name = :name and ld_objectid = :objectId and ld_tenantid = :tenantId";
        try {
            long sequenceId = this.queryForLong(query, Map.of(TENANTID, tenantId, "objectId", objectId, "name", sequenceName));
            if (sequenceId != 0L) {
                sequence = (Sequence)this.findById(sequenceId);
            }
        }
        catch (Exception t) {
            this.log.warn(t.getMessage(), t);
        }
        return sequence;
    }

    private List<Sequence> findSequences(String sequenceName, long objectId, long tenantId) {
        List<Sequence> sequences = new ArrayList<Sequence>();
        try {
            Object query = " _entity.tenantId = :tenantId ";
            query = (String)query + " and _entity.objectId = :objectId ";
            query = (String)query + " and _entity.name = :name ";
            sequences = this.findByWhere((String)query, Map.of(TENANTID, tenantId, "objectId", objectId, "name", sequenceName), null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sequences;
    }

    @Override
    public void delete(String name, long objectId, long tenantId) throws PersistenceException {
        Sequence seq = this.findByAlternateKey(name, objectId, tenantId);
        if (seq != null) {
            this.delete(seq.getId());
        }
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        Sequence seq = (Sequence)this.findById(id);
        if (seq != null) {
            seq.setName(seq.getId() + "." + seq.getName());
            seq.setDeleted(code);
            this.store(seq);
        }
    }
}

