/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class WorkingTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int dayOfWeek = 1;
    private int hourStart = 0;
    private int minuteStart = 0;
    private int hourEnd = 0;
    private int minuteEnd = 0;
    private String label;
    private String description;

    public WorkingTime() {
    }

    public WorkingTime(int dayOfWeek, int hourStart, int minuteStart) {
        this.dayOfWeek = dayOfWeek;
        this.hourStart = hourStart;
        this.hourEnd = hourStart < 23 ? hourStart + 1 : hourStart;
        this.minuteStart = minuteStart;
        this.minuteEnd = minuteStart;
    }

    public WorkingTime(WorkingTime source) {
        this.dayOfWeek = source.dayOfWeek;
        this.hourStart = source.hourStart;
        this.minuteStart = source.minuteStart;
        this.hourEnd = source.hourEnd;
        this.minuteEnd = source.minuteEnd;
        this.label = source.label;
        this.description = source.description;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public int getHourStart() {
        return this.hourStart;
    }

    public void setHourStart(int hourStart) {
        this.hourStart = hourStart;
    }

    public int getMinuteStart() {
        return this.minuteStart;
    }

    public void setMinuteStart(int minuteStart) {
        this.minuteStart = minuteStart;
    }

    public int getHourEnd() {
        return this.hourEnd;
    }

    public void setHourEnd(int hourEnd) {
        this.hourEnd = hourEnd;
    }

    public int getMinuteEnd() {
        return this.minuteEnd;
    }

    public void setMinuteEnd(int minuteEnd) {
        this.minuteEnd = minuteEnd;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private Date dateStart() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, this.hourStart);
        cal.set(12, this.minuteStart);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date dateEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, this.hourEnd);
        cal.set(12, this.minuteEnd);
        cal.set(13, 59);
        cal.set(14, 900);
        return cal.getTime();
    }

    public boolean matchesCurrentTime() {
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        return this.getDayOfWeek() == cal.get(7) && now.after(this.dateStart()) && now.before(this.dateEnd());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dayOfWeek;
        result = 31 * result + this.hourEnd;
        result = 31 * result + this.hourStart;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkingTime other = (WorkingTime)obj;
        if (this.dayOfWeek != other.dayOfWeek) {
            return false;
        }
        if (this.hourEnd != other.hourEnd) {
            return false;
        }
        return this.hourStart == other.hourStart;
    }
}

