/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import com.logicaldoc.core.security.user.UserListener;
import com.logicaldoc.util.plugin.PluginRegistry;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="userListenerManager")
public class UserListenerManager {
    private static final String POSITION = "position";
    private static final Logger log = LoggerFactory.getLogger(UserListenerManager.class);
    private List<UserListener> listeners = new ArrayList<UserListener>();

    @PostConstruct
    public void init() {
        if (!this.listeners.isEmpty()) {
            return;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "UserListener");
        ArrayList<Extension> sortedExts = new ArrayList<Extension>();
        for (Extension extension : exts) {
            sortedExts.add(extension);
        }
        Collections.sort(sortedExts, (e1, e2) -> {
            int position2;
            int position1 = Integer.parseInt(e1.getParameter(POSITION).valueAsString());
            if (position1 < (position2 = Integer.parseInt(e2.getParameter(POSITION).valueAsString()))) {
                return -1;
            }
            if (position1 > position2) {
                return 1;
            }
            return 0;
        });
        for (Extension ext : sortedExts) {
            String className = ext.getParameter("class").valueAsString();
            try {
                Class<?> clazz = Class.forName(className);
                Object listener = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(listener instanceof UserListener)) {
                    throw new ClassNotFoundException("The specified listener " + className + " doesn't implement UserListener interface");
                }
                this.listeners.add((UserListener)listener);
                if (!log.isInfoEnabled()) continue;
                log.info("Added new user listener {} position {}", (Object)className, (Object)ext.getParameter(POSITION).valueAsString());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error(e.getMessage());
            }
        }
    }

    public List<UserListener> getListeners() {
        if (this.listeners == null) {
            this.init();
        }
        return this.listeners;
    }
}

