/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import com.logicaldoc.core.history.History;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.UserEvent;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;

@Entity
@Table(name="ld_user_history")
@Cacheable
public class UserHistory
extends History {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_author", length=255)
    private String author;
    @Column(name="ld_filename", length=255)
    private String filename = null;
    @Column(name="ld_filesize")
    private Long fileSize = null;
    @Column(name="ld_docid")
    private Long docId;
    @Column(name="ld_folderid")
    private Long folderId;

    public UserHistory() {
    }

    public UserHistory(Session session) {
        this.setSession(session);
    }

    public UserHistory(UserHistory source) {
        this.copyAttributesFrom(source);
        this.author = source.author;
        this.filename = source.filename;
        this.fileSize = source.fileSize;
        this.folderId = source.folderId;
        this.docId = source.docId;
    }

    public void setEvent(UserEvent event) {
        this.event = event != null ? event.toString() : null;
    }

    @Override
    public void setEvent(String event) {
        this.setEvent(UserEvent.fromKey(event));
    }

    public UserEvent getEventEnum() {
        if (this.event == null) {
            return null;
        }
        return UserEvent.fromKey(this.event);
    }

    public Long getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public Long getDocId() {
        return this.docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserHistory other = (UserHistory)obj;
        return !(this.author == null ? other.author != null : !this.author.equals(other.author));
    }
}

