/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.UserGroup;
import com.logicaldoc.core.security.user.UserSource;
import com.logicaldoc.core.security.user.UserType;
import com.logicaldoc.core.security.user.WorkingTime;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.crypt.CryptUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="ld_user")
@Cacheable
public class User
extends PersistentObject
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(User.class);
    public static final long USERID_ADMIN = 1L;
    public static final long USERID_SYSTEM = -1010L;
    private static final long serialVersionUID = 8093874904302301982L;
    @Column(name="ld_type", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private UserType type = UserType.DEFAULT;
    @Column(name="ld_source", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private UserSource source = UserSource.DEFAULT;
    @Column(name="ld_username", length=255, nullable=false)
    private String username = "";
    @Column(name="ld_password", length=255)
    private String password = "";
    @Column(name="ld_passwordmd4", length=255)
    private String passwordmd4 = "";
    @Column(name="ld_name", length=255)
    private String name = "";
    @Column(name="ld_firstname", length=255)
    private String firstName = "";
    @Column(name="ld_street", length=255)
    private String street = "";
    @Column(name="ld_postalcode", length=255)
    private String postalcode = "";
    @Column(name="ld_city", length=255)
    private String city = "";
    @Column(name="ld_country", length=255)
    private String country = "";
    @Column(name="ld_state", length=255)
    private String state = "";
    @Column(name="ld_language", length=10)
    private String language = "";
    @Column(name="ld_email", length=255)
    private String email = "";
    @Column(name="ld_emailsignature", length=1000)
    private String emailSignature;
    @Column(name="ld_email2", length=255)
    private String email2 = "";
    @Column(name="ld_emailsignature2", length=1000)
    private String emailSignature2;
    @Column(name="ld_telephone", length=255)
    private String telephone = "";
    @Column(name="ld_telephone2", length=255)
    private String telephone2 = "";
    @Transient
    private Set<Group> groups = new HashSet<Group>();
    @Column(name="ld_enabled", nullable=false)
    private int enabled = 1;
    @Column(name="ld_legals", nullable=false)
    private int legals = 0;
    @Column(name="ld_passwordchanged", columnDefinition="DATETIME(3)")
    private Date passwordChanged = new Date();
    @Column(name="ld_passwordexpires", nullable=false)
    private int passwordExpires = 0;
    @Column(name="ld_passwordexpired", nullable=false)
    private int passwordExpired = 0;
    @Transient
    private String repass;
    @Column(name="ld_quota", nullable=false)
    private long quota = -1L;
    @Column(name="ld_welcomescreen", nullable=true)
    private Integer welcomeScreen = 1520;
    @Column(name="ld_defworkspace")
    private Long defaultWorkspace;
    @Column(name="ld_ipwhitelist", length=1000, nullable=true)
    private String ipWhiteList;
    @Column(name="ld_ipblacklist", length=1000, nullable=true)
    private String ipBlackList;
    @Column(name="ld_certexpire", columnDefinition="DATETIME(3)")
    private Date certExpire;
    @Column(name="ld_certdn", length=1000)
    private String certDN;
    @Column(name="ld_secondfactor", length=255)
    private String secondFactor;
    @Column(name="ld_key", length=255)
    private String key;
    @Column(name="ld_docsgrid", nullable=true)
    private String docsGrid;
    @Column(name="ld_hitsgrid", nullable=true)
    private String hitsGrid;
    @Column(name="ld_dateformat", length=255)
    private String dateFormat;
    @Column(name="ld_dateformatshort", length=255)
    private String dateFormatShort;
    @Column(name="ld_dateformatlong", length=255)
    private String dateFormatLong;
    @Column(name="ld_searchpref", length=255)
    private String searchPref;
    @Column(name="ld_lastenabled")
    private Date lastEnabled;
    @Column(name="ld_expire", columnDefinition="DATETIME(3)")
    private Date expire;
    @Column(name="ld_enforcewrktime", nullable=false)
    private int enforceWorkingTime = 0;
    @Column(name="ld_maxinactivity")
    private Integer maxInactivity;
    @Column(name="ld_timezone")
    private String timeZone;
    @Column(name="ld_avatar")
    private String avatar;
    @Column(name="ld_lastlogin", columnDefinition="DATETIME(3)")
    private Date lastLogin = new Date();
    @Transient
    private String decodedPassword;
    @Transient
    private Set<UserGroup> userGroups = new HashSet<UserGroup>();
    @Transient
    private Set<WorkingTime> workingTimes = new HashSet<WorkingTime>();
    @Column(name="ld_department", length=255)
    private String department;
    @Column(name="ld_organizationalunit", length=255)
    private String organizationalUnit;
    @Column(name="ld_building", length=255)
    private String building;
    @Column(name="ld_company", length=255)
    private String company;
    @Column(name="ld_evalform", nullable=false)
    private int evalFormEnabled = 1;

    public int getEvalFormEnabled() {
        return this.evalFormEnabled;
    }

    public void setEvalFormEnabled(int evalFormEnabled) {
        this.evalFormEnabled = evalFormEnabled;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public UserType getType() {
        return this.type;
    }

    public void setType(UserType type) {
        this.type = type;
    }

    public void setType(int type) {
        this.type = UserType.values()[type];
    }

    public String getRepass() {
        return this.repass;
    }

    public void setRepass(String repass) {
        this.repass = repass;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        Object fullName = this.getFirstName();
        if (fullName != null && this.getName() != null) {
            fullName = (String)fullName + " " + this.getName();
        }
        if (fullName == null && this.getName() != null) {
            fullName = this.getName();
        }
        if (fullName == null) {
            fullName = this.getUsername();
        }
        return fullName;
    }

    public String getInitials() {
        String[] tokens;
        StringBuilder sb = new StringBuilder();
        String fullName = this.getFullName();
        String[] stringArray = tokens = fullName.split(" ");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.trim().isEmpty()) {
                sb.append(token.trim().toUpperCase().substring(0, 1));
            }
            ++n2;
        }
        return sb.toString();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getStreet() {
        return this.street;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public boolean isAdmin() {
        return this.isMemberOf("admin");
    }

    public boolean isMemberOf(String groupName) {
        return this.groups.stream().anyMatch(g -> groupName.equals(g.getName()));
    }

    public void addGroup(Group group) {
        if (group == null) {
            return;
        }
        if (!this.getGroups().contains(group)) {
            this.getGroups().add(group);
        }
        UserGroup ug = new UserGroup(group.getId());
        if (!this.getUserGroups().contains(ug)) {
            this.getUserGroups().add(ug);
        }
    }

    public void removeGroup(long groupId) {
        Iterator<UserGroup> iter = this.getUserGroups().iterator();
        while (iter.hasNext()) {
            UserGroup p = iter.next();
            if (p.getGroupId() != groupId) continue;
            iter.remove();
        }
        Iterator<Group> iter2 = this.getGroups().iterator();
        while (iter2.hasNext()) {
            Group p = iter2.next();
            if (p.getId() != groupId) continue;
            iter2.remove();
        }
    }

    public void removeGroupMemberships(String source) {
        Iterator<Group> iter = this.getGroups().iterator();
        while (iter.hasNext()) {
            Group grp = iter.next();
            if (this.getUserGroupName().equals(grp.getName()) || source != null && !source.equals(grp.getSource())) continue;
            iter.remove();
            this.getUserGroups().remove(new UserGroup(grp.getId()));
        }
    }

    public void setUsername(String uname) {
        this.username = uname;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public void setDecodedPassword(String pwd) throws NoSuchAlgorithmException {
        if (StringUtils.isEmpty((CharSequence)pwd)) {
            throw new NoSuchAlgorithmException("Password cannot be empty");
        }
        this.decodedPassword = pwd;
        this.password = CryptUtil.encryptSHA256(pwd);
        if (StringUtils.isEmpty((CharSequence)this.password)) {
            throw new NoSuchAlgorithmException("Password cannot be empty");
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setStreet(String str) {
        this.street = str;
    }

    public void setPostalcode(String pc) {
        this.postalcode = pc;
    }

    public void setCity(String ct) {
        this.city = ct;
    }

    public void setCountry(String cnt) {
        this.country = cnt;
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public void setEmail(String mail) {
        this.email = mail;
    }

    public void setTelephone(String phone) {
        this.telephone = phone;
    }

    public void reset() {
        this.username = "";
        this.password = "";
        this.passwordmd4 = "";
        this.name = "";
        this.firstName = "";
        this.street = "";
        this.postalcode = "";
        this.city = "";
        this.country = "";
        this.language = "";
        this.email = "";
        this.telephone = "";
        this.docsGrid = null;
        this.hitsGrid = null;
        this.groups = new HashSet<Group>();
        this.passwordExpires = 0;
        this.avatar = null;
        this.expire = null;
        this.enforceWorkingTime = 0;
        this.lastLogin = null;
        this.workingTimes = new HashSet<WorkingTime>();
        this.building = null;
        this.organizationalUnit = null;
        this.department = null;
    }

    @Override
    public String toString() {
        return this.getUsername();
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public String getUserGroupName() {
        return "_user_" + this.getId();
    }

    public Group getUserGroup() throws PersistenceException {
        if (this.getGroups() != null) {
            for (Group grp : this.getGroups()) {
                if (!grp.getName().equals(this.getUserGroupName())) continue;
                return grp;
            }
        }
        log.warn("User {} has lost association with his group", (Object)this.username);
        GroupDAO dao = Context.get(GroupDAO.class);
        Group group = dao.findByName(this.getUserGroupName(), this.getTenantId());
        if (group == null) {
            log.warn("User {} doesn't have his user group {}", (Object)this.username, (Object)this.getUserGroupName());
        }
        return group;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getTelephone2() {
        return this.telephone2;
    }

    public void setTelephone2(String telephone2) {
        this.telephone2 = telephone2;
    }

    public Locale getLocale() {
        return LocaleUtil.toLocale(this.getLanguage());
    }

    public void setLocale(Locale locale) {
        this.setLanguage(locale.toString());
    }

    public Date getPasswordChanged() {
        return this.passwordChanged;
    }

    public void setPasswordChanged(Date passwordChanged) {
        this.passwordChanged = passwordChanged;
    }

    public int getPasswordExpires() {
        return this.passwordExpires;
    }

    public void setPasswordExpires(int passwordExpires) {
        this.passwordExpires = passwordExpires;
    }

    public UserSource getSource() {
        return this.source;
    }

    public void setSource(UserSource source) {
        this.source = source;
    }

    public void setSource(int source) {
        this.source = UserSource.values()[source];
    }

    public long getQuota() {
        return this.quota;
    }

    public void setQuota(long quota) {
        this.quota = quota;
    }

    public Integer getWelcomeScreen() {
        return this.welcomeScreen;
    }

    public void setWelcomeScreen(Integer welcomeScreen) {
        this.welcomeScreen = welcomeScreen;
    }

    public String getIpWhiteList() {
        return this.ipWhiteList;
    }

    public void setIpWhiteList(String ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public String getIpBlackList() {
        return this.ipBlackList;
    }

    public void setIpBlackList(String ipBlackList) {
        this.ipBlackList = ipBlackList;
    }

    public int getPasswordExpired() {
        return this.passwordExpired;
    }

    public void setPasswordExpired(int passwordExpired) {
        this.passwordExpired = passwordExpired;
    }

    public String getPasswordmd4() {
        return this.passwordmd4;
    }

    public void setPasswordmd4(String passwordmd4) {
        this.passwordmd4 = passwordmd4;
    }

    public String getDecodedPassword() {
        return this.decodedPassword;
    }

    public String getEmailSignature() {
        return this.emailSignature;
    }

    public void setEmailSignature(String emailSignature) {
        this.emailSignature = emailSignature;
    }

    public void clearPassword() {
    }

    public Long getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    public void setDefaultWorkspace(Long defaultWorkspace) {
        this.defaultWorkspace = defaultWorkspace;
    }

    public String getEmail2() {
        return this.email2;
    }

    public void setEmail2(String email2) {
        this.email2 = email2;
    }

    public String getEmailSignature2() {
        return this.emailSignature2;
    }

    public void setEmailSignature2(String emailSignature2) {
        this.emailSignature2 = emailSignature2;
    }

    public Set<UserGroup> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(Set<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    public Date getCertExpire() {
        return this.certExpire;
    }

    public void setCertExpire(Date certExpire) {
        this.certExpire = certExpire;
    }

    public String getCertDN() {
        return this.certDN;
    }

    public void setCertDN(String certDN) {
        this.certDN = certDN;
    }

    public String getSecondFactor() {
        return this.secondFactor;
    }

    public void setSecondFactor(String secondFactor) {
        this.secondFactor = secondFactor;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isReadonly() {
        return this.type == UserType.READONLY;
    }

    public String getDocsGrid() {
        return this.docsGrid;
    }

    public void setDocsGrid(String docsGrid) {
        this.docsGrid = docsGrid;
    }

    public String getHitsGrid() {
        return this.hitsGrid;
    }

    public void setHitsGrid(String hitsGrid) {
        this.hitsGrid = hitsGrid;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormatShort() {
        return this.dateFormatShort;
    }

    public void setDateFormatShort(String dateFormatShort) {
        this.dateFormatShort = dateFormatShort;
    }

    public String getDateFormatLong() {
        return this.dateFormatLong;
    }

    public void setDateFormatLong(String dateFormatLong) {
        this.dateFormatLong = dateFormatLong;
    }

    public String getSearchPref() {
        return this.searchPref;
    }

    public void setSearchPref(String searchPref) {
        this.searchPref = searchPref;
    }

    public Date getExpire() {
        return this.expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public Date getLastEnabled() {
        return this.lastEnabled;
    }

    public void setLastEnabled(Date lastEnabled) {
        this.lastEnabled = lastEnabled;
    }

    public boolean isExpired() {
        return this.getExpire() != null && this.getExpire().before(new Date());
    }

    public boolean isInWorkingTime() {
        if (this.getWorkingTimes() != null) {
            for (WorkingTime wt : this.getWorkingTimes()) {
                if (!wt.matchesCurrentTime()) continue;
                return true;
            }
        }
        return false;
    }

    public int getEnforceWorkingTime() {
        return this.enforceWorkingTime;
    }

    public void setEnforceWorkingTime(int enforceWorkingTime) {
        this.enforceWorkingTime = enforceWorkingTime;
    }

    public Set<WorkingTime> getWorkingTimes() {
        return this.workingTimes;
    }

    public void setWorkingTimes(Set<WorkingTime> workingTimes) {
        this.workingTimes = workingTimes;
    }

    public Integer getMaxInactivity() {
        return this.maxInactivity;
    }

    public void setMaxInactivity(Integer maxInactivity) {
        this.maxInactivity = maxInactivity;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public int getLegals() {
        return this.legals;
    }

    public void setLegals(int legals) {
        this.legals = legals;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

