/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import com.logicaldoc.core.PersistentObject;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="ld_password_history")
@Cacheable
public class PasswordHistory
extends PersistentObject
implements Serializable,
Comparable<PasswordHistory> {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_userid", nullable=false)
    private long userId;
    @Column(name="ld_date", columnDefinition="DATETIME(3)")
    private Date date = new Date();
    @Column(name="ld_password")
    private String password = "";

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public int compareTo(PasswordHistory other) {
        if (this.equals(other)) {
            return 0;
        }
        if (other.userId == this.userId) {
            return this.date.compareTo(other.date);
        }
        return Long.compare(this.userId, other.userId);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PasswordHistory other = (PasswordHistory)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return this.userId == other.userId;
    }
}

