/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.history.HibernateHistoryDAO;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.core.security.user.UserHistoryDAO;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="userHistoryDAO")
@Transactional
public class HibernateUserHistoryDAO
extends HibernateHistoryDAO<UserHistory>
implements UserHistoryDAO {
    private HibernateUserHistoryDAO() {
        super(UserHistory.class);
        this.log = LoggerFactory.getLogger(HibernateUserHistoryDAO.class);
    }

    @Override
    public List<UserHistory> findByUserId(long userId) {
        return this.findByUserIdAndEvent(userId, null);
    }

    @Override
    public List<UserHistory> findByUserIdAndEvent(long userId, String event) {
        try {
            if (StringUtils.isEmpty(event)) {
                return this.findByWhere("_entity.userId =" + userId, "_entity.date desc", null);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("userId", userId);
            params.put("event", event);
            return this.findByWhere("_entity.userId = :userId and _entity.event = :event", params, "_entity.date desc", null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<UserHistory>();
        }
    }

    @Override
    public UserHistory createUserHistory(User user, UserEvent eventType, String comment, String sessionId, Client client) {
        UserHistory history = new UserHistory();
        history.setComment(comment);
        history.setEvent(eventType);
        Session session = SessionManager.get().get(sessionId);
        if (session != null) {
            history.setSession(session);
        } else {
            history.setSessionId(sessionId);
        }
        if (user != null) {
            history.setUser(user);
        }
        if (client != null) {
            history.setIp(client.getAddress());
            if (client.getDevice() != null) {
                history.setDevice(client.getDevice().toString());
            }
            if (client.getGeolocation() != null) {
                history.setGeolocation(client.getGeolocation().toString());
            }
        }
        try {
            this.store(history);
            return history;
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void cleanOldHistories(int ttl) {
        try {
            this.log.info("cleanOldHistories rows updated: {}", (Object)this.cleanOldRecords(ttl, "ld_user_history"));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
    }
}

